/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.system;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import sun.nio.ch.DirectBuffer;

public interface DirectMemUtil {
    public static final int REUSABLE_BUFF_SIZE_MIN = 1;
    public static final int REUSABLE_BUFF_SIZE_MAX = 0x1000000;
    public static final ThreadLocal<MappedByteBuffer[]> REUSABLE_BUFFS = ThreadLocal.withInitial(() -> {
        int buffCount = (int)(Math.log(1.6777216E7) / Math.log(2.0) + 1.0);
        return new MappedByteBuffer[buffCount];
    });

    public static boolean free(MappedByteBuffer buff) {
        if (buff == null) {
            return false;
        }
        ((DirectBuffer)((Object)buff)).cleaner().clean();
        return true;
    }

    public static MappedByteBuffer getThreadLocalReusableBuff(long size) throws IllegalArgumentException {
        if (size < 0L) {
            throw new IllegalArgumentException("Requested negative buffer size: " + size);
        }
        MappedByteBuffer[] threadLocalReusableBuffers = REUSABLE_BUFFS.get();
        long currBuffSize = Long.highestOneBit(size);
        if (currBuffSize > 0x1000000L) {
            currBuffSize = 0x1000000L;
        } else if (currBuffSize < 0x1000000L) {
            if (currBuffSize < 1L) {
                currBuffSize = 1L;
            } else if (currBuffSize < size) {
                currBuffSize <<= 1;
            }
        }
        int i = Long.numberOfTrailingZeros(currBuffSize);
        MappedByteBuffer buff = threadLocalReusableBuffers[i];
        if (buff == null) {
            threadLocalReusableBuffers[i] = buff = (MappedByteBuffer)ByteBuffer.allocateDirect((int)currBuffSize);
        }
        buff.position(0).limit(size < (long)buff.capacity() ? Math.max(1, (int)size) : buff.capacity());
        return buff;
    }
}

