/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.concurrent;

import com.github.akurilov.commons.concurrent.AsyncRunnable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AsyncRunnableBase
implements AsyncRunnable {
    private volatile AsyncRunnable.State state = AsyncRunnable.State.INITIAL;
    private final Lock stateLock = new ReentrantLock();
    private final Condition stateChanged = this.stateLock.newCondition();

    @Override
    public final AsyncRunnable.State state() {
        return this.state;
    }

    @Override
    public boolean isInitial() {
        return AsyncRunnable.State.INITIAL == this.state;
    }

    @Override
    public boolean isStarted() {
        return AsyncRunnable.State.STARTED == this.state;
    }

    @Override
    public boolean isShutdown() {
        return AsyncRunnable.State.SHUTDOWN == this.state;
    }

    @Override
    public boolean isStopped() {
        return AsyncRunnable.State.STOPPED == this.state;
    }

    @Override
    public boolean isFinished() {
        return AsyncRunnable.State.FINISHED == this.state;
    }

    @Override
    public boolean isClosed() {
        return null == this.state;
    }

    @Override
    public final AsyncRunnableBase start() throws IllegalStateException {
        block4: {
            this.stateLock.lock();
            try {
                if (this.state == AsyncRunnable.State.INITIAL || this.state == AsyncRunnable.State.STOPPED) {
                    this.doStart();
                    this.state = AsyncRunnable.State.STARTED;
                    this.stateChanged.signalAll();
                    break block4;
                }
                throw new IllegalStateException("Not allowed to start while state is \"" + (Object)((Object)this.state) + "\"");
            }
            finally {
                this.stateLock.unlock();
            }
        }
        return this;
    }

    @Override
    public final AsyncRunnableBase shutdown() throws IllegalStateException {
        block4: {
            this.stateLock.lock();
            try {
                if (this.state == AsyncRunnable.State.STARTED) {
                    this.doShutdown();
                    this.state = AsyncRunnable.State.SHUTDOWN;
                    this.stateChanged.signalAll();
                    break block4;
                }
                throw new IllegalStateException("Not allowed to shutdown while state is \"" + (Object)((Object)this.state) + "\"");
            }
            finally {
                this.stateLock.unlock();
            }
        }
        return this;
    }

    @Override
    public final AsyncRunnableBase stop() throws IllegalStateException {
        block4: {
            this.stateLock.lock();
            try {
                if (this.state == AsyncRunnable.State.STARTED || this.state == AsyncRunnable.State.SHUTDOWN) {
                    this.doStop();
                    this.state = AsyncRunnable.State.STOPPED;
                    this.stateChanged.signalAll();
                    break block4;
                }
                throw new IllegalStateException("Not allowed to stop while state is \"" + (Object)((Object)this.state) + "\"");
            }
            finally {
                this.stateLock.unlock();
            }
        }
        return this;
    }

    @Override
    public final AsyncRunnableBase await() throws IllegalStateException, InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long timeout, TimeUnit timeUnit) throws IllegalStateException, InterruptedException {
        long elapsedTimeMillis;
        long invokeTimeMillis = System.currentTimeMillis();
        long timeOutMillis = timeUnit.toMillis(timeout);
        while (timeOutMillis > (elapsedTimeMillis = System.currentTimeMillis() - invokeTimeMillis)) {
            if (this.state != AsyncRunnable.State.STARTED && this.state != AsyncRunnable.State.SHUTDOWN) {
                return true;
            }
            if (!this.stateLock.tryLock(timeOutMillis - elapsedTimeMillis, TimeUnit.MILLISECONDS)) continue;
            try {
                elapsedTimeMillis = System.currentTimeMillis() - invokeTimeMillis;
                if (timeOutMillis > elapsedTimeMillis) {
                    if (!this.stateChanged.await(timeOutMillis - elapsedTimeMillis, TimeUnit.MILLISECONDS) || this.state == AsyncRunnable.State.STARTED || this.state == AsyncRunnable.State.SHUTDOWN) continue;
                    boolean bl = true;
                    return bl;
                }
                break;
            }
            finally {
                this.stateLock.unlock();
            }
        }
        return this.state != AsyncRunnable.State.STARTED && this.state != AsyncRunnable.State.SHUTDOWN;
    }

    @Override
    public void close() throws IllegalStateException, IOException {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.stateLock.lock();
        try {
            if (null != this.state) {
                this.doClose();
                this.state = null;
                this.stateChanged.signalAll();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected void doStart() {
    }

    protected void doShutdown() {
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }
}

