/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public interface NetUtil {
    public static InetAddress getHostAddr() throws SocketException {
        InetAddress addr = null;
        Enumeration<NetworkInterface> netIfaces = NetworkInterface.getNetworkInterfaces();
        while (netIfaces.hasMoreElements()) {
            NetworkInterface nextNetIface = netIfaces.nextElement();
            if (nextNetIface.isLoopback() || !nextNetIface.isUp()) continue;
            Enumeration<InetAddress> addrs = nextNetIface.getInetAddresses();
            while (addrs.hasMoreElements() && !Inet4Address.class.isInstance(addr = addrs.nextElement())) {
            }
        }
        if (addr == null) {
            addr = InetAddress.getLoopbackAddress();
        }
        if (addr == null) {
            throw new IllegalStateException("No network interface found");
        }
        return addr;
    }

    public static String getHostAddrString() throws SocketException, IllegalStateException {
        return NetUtil.getHostAddr().getHostAddress();
    }

    public static long getHostAddrCode() throws SocketException, IllegalStateException {
        return NetUtil.getHostAddrString().hashCode();
    }

    public static String addPortIfMissing(String addr, int defaultPort) {
        if (addr.contains(":")) {
            return addr;
        }
        return addr + ':' + Integer.toString(defaultPort);
    }
}

