/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.reflection;

import java.util.Arrays;
import java.util.List;

public interface TypeUtil {
    public static boolean typeEquals(Class cls1, Class cls2) {
        if (cls1.equals(cls2)) {
            return true;
        }
        Object primitiveType1 = null;
        try {
            primitiveType1 = cls1.getField("TYPE").get(cls1);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        Object primitiveType2 = null;
        try {
            primitiveType2 = cls2.getField("TYPE").get(cls2);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        if (primitiveType1 == null) {
            if (primitiveType2 == null) {
                return false;
            }
            return cls1.equals(primitiveType2);
        }
        if (primitiveType2 == null) {
            return cls2.equals(primitiveType1);
        }
        return primitiveType1.equals(primitiveType2);
    }

    public static <T> T typeConvert(Object val, Class<T> cls) throws ClassCastException {
        Class<?> valCls;
        if (val == null) {
            if (cls.isPrimitive()) {
                throw new ClassCastException("Cannot cast null to a primitive type");
            }
            return null;
        }
        if (val instanceof Byte) {
            Byte b = (Byte)val;
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                throw new ClassCastException("Cannot cast byte to boolean");
            }
            if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
                return (T)Character.valueOf((char)(b & 0xFF));
            }
            if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
                return (T)Short.valueOf(b.shortValue());
            }
            if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
                return (T)Integer.valueOf(b.intValue());
            }
            if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
                return (T)Long.valueOf(b.longValue());
            }
            if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
                return (T)Float.valueOf(b.floatValue());
            }
            if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
                return (T)Double.valueOf(b.doubleValue());
            }
            if (cls.equals(String.class)) {
                return (T)val;
            }
        }
        if (val instanceof Short) {
            Short v = (Short)val;
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                throw new ClassCastException("Cannot cast short to boolean");
            }
            if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
                throw new ClassCastException("Cannot cast short to byte");
            }
            if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
                return (T)Character.valueOf((char)(v & 0xFFFF));
            }
            if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
                return (T)Integer.valueOf(v.intValue());
            }
            if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
                return (T)Long.valueOf(v.longValue());
            }
            if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
                return (T)Float.valueOf(v.floatValue());
            }
            if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
                return (T)Double.valueOf(v.doubleValue());
            }
            if (cls.equals(String.class)) {
                return (T)val;
            }
        }
        if (val instanceof Character) {
            char c = ((Character)val).charValue();
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                throw new ClassCastException("Cannot cast char to boolean");
            }
            if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
                throw new ClassCastException("Cannot cast char to byte");
            }
            if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
                throw new ClassCastException("Cannot cast char to short");
            }
            if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
                return (T)Integer.valueOf(c);
            }
            if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
                return (T)Long.valueOf(c);
            }
            if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
                return (T)Float.valueOf(c);
            }
            if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
                return (T)Double.valueOf(c);
            }
            if (cls.equals(String.class)) {
                return (T)val;
            }
        }
        if (val instanceof Integer) {
            Integer i = (Integer)val;
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                throw new ClassCastException("Cannot cast int to boolean");
            }
            if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
                throw new ClassCastException("Cannot cast int to byte");
            }
            if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
                throw new ClassCastException("Cannot cast int to short");
            }
            if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
                throw new ClassCastException("Cannot cast int to char");
            }
            if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
                return (T)Long.valueOf(i.longValue());
            }
            if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
                return (T)Float.valueOf(i.floatValue());
            }
            if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
                return (T)Double.valueOf(i.doubleValue());
            }
            if (cls.equals(String.class)) {
                return (T)val;
            }
        }
        if (val instanceof Long) {
            Long v = (Long)val;
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                throw new ClassCastException("Cannot cast long to boolean");
            }
            if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
                throw new ClassCastException("Cannot cast long to byte");
            }
            if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
                throw new ClassCastException("Cannot cast long to short");
            }
            if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
                throw new ClassCastException("Cannot cast long to char");
            }
            if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
                throw new ClassCastException("Cannot cast long to int");
            }
            if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
                return (T)Float.valueOf(v.floatValue());
            }
            if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
                return (T)Double.valueOf(v.doubleValue());
            }
            if (cls.equals(String.class)) {
                return (T)val;
            }
        }
        if (val instanceof Float) {
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                throw new ClassCastException("Cannot cast float to boolean");
            }
            if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
                throw new ClassCastException("Cannot cast float to byte");
            }
            if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
                throw new ClassCastException("Cannot cast float to short");
            }
            if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
                throw new ClassCastException("Cannot cast float to char");
            }
            if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
                throw new ClassCastException("Cannot cast float to int");
            }
            if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
                throw new ClassCastException("Cannot cast float to long");
            }
            if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
                return (T)Double.valueOf(((Float)val).doubleValue());
            }
            if (cls.equals(String.class)) {
                return (T)val;
            }
        }
        if (val instanceof Double) {
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                throw new ClassCastException("Cannot cast double to boolean");
            }
            if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
                throw new ClassCastException("Cannot cast double to byte");
            }
            if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
                throw new ClassCastException("Cannot cast double to short");
            }
            if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
                throw new ClassCastException("Cannot cast double to char");
            }
            if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
                throw new ClassCastException("Cannot cast double to int");
            }
            if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
                throw new ClassCastException("Cannot cast double to long");
            }
            if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
                throw new ClassCastException("Cannot cast double to float");
            }
            if (cls.equals(String.class)) {
                return (T)val;
            }
        }
        if (val instanceof String) {
            String s = (String)val;
            if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(s));
            }
            if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
                return (T)Byte.valueOf(Byte.parseByte(s));
            }
            if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
                return (T)Short.valueOf(Short.parseShort(s));
            }
            if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
                if (s.length() == 1) {
                    return (T)Character.valueOf(s.charAt(0));
                }
                throw new ClassCastException("Cannot cast string to char");
            }
            if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
                return (T)Integer.valueOf(Integer.parseInt(s));
            }
            if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
                return (T)Long.valueOf(Long.parseLong(s));
            }
            if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
                return (T)Float.valueOf(Float.parseFloat(s));
            }
            if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
                return (T)Double.valueOf(Double.parseDouble(s));
            }
            if (cls.equals(List.class)) {
                return (T)Arrays.asList(s.split(","));
            }
        }
        if (cls.isAssignableFrom(valCls = val.getClass()) || TypeUtil.typeEquals(cls, valCls)) {
            return (T)val;
        }
        throw new ClassCastException("Cannot cast " + valCls + " to " + cls);
    }
}

