/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Realm;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;

public class DataSourceRealm
extends RealmBase {
    private String dataSourceName;
    private boolean localDataSource;
    private String userQuery;
    private String roleQuery;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean localDataSource) {
        this.localDataSource = localDataSource;
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public void setUserQuery(String userQuery) {
        this.userQuery = userQuery;
    }

    public String getRoleQuery() {
        return this.roleQuery;
    }

    public void setRoleQuery(String rolesQuery) {
        this.roleQuery = rolesQuery;
    }

    protected String getName() {
        return "JbpmConsoleRealm";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPassword(String username) {
        Connection dbConnection = this.open();
        if (dbConnection != null) {
            try {
                String string = this.getPassword(dbConnection, username);
                return string;
            }
            finally {
                this.close(dbConnection);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPassword(Connection dbConnection, String username) {
        PreparedStatement statement = null;
        try {
            statement = dbConnection.prepareStatement(this.userQuery);
            statement.setString(1, username);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", (Object)username));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", (Object)username));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal getPrincipal(String username) {
        Connection dbConnection = this.open();
        if (dbConnection != null) {
            try {
                GenericPrincipal genericPrincipal = new GenericPrincipal((Realm)this, username, this.getPassword(dbConnection, username), this.getRoles(dbConnection, username));
                return genericPrincipal;
            }
            finally {
                this.close(dbConnection);
            }
        }
        return new GenericPrincipal((Realm)this, username, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getRoles(Connection dbConnection, String username) {
        PreparedStatement statement = null;
        try {
            statement = dbConnection.prepareStatement(this.roleQuery);
            statement.setString(1, username);
            ResultSet rs = statement.executeQuery();
            ArrayList<String> roles = new ArrayList<String>();
            while (rs.next()) {
                roles.add(rs.getString(1));
            }
            ArrayList<String> arrayList = roles;
            return arrayList;
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", (Object)username));
            List list = null;
            return list;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", (Object)username));
                }
            }
        }
    }

    private Connection open() {
        try {
            Context context;
            if (this.localDataSource) {
                context = (Context)ContextBindings.getClassLoader().lookup("comp/env");
            } else {
                StandardServer server = (StandardServer)ServerFactory.getServer();
                context = server.getGlobalNamingContext();
            }
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            return dataSource.getConnection();
        }
        catch (NamingException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)e);
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)e);
        }
        return null;
    }

    private void close(Connection dbConnection) {
        try {
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            this.containerLog.error((Object)"Exception committing connection before closing:", (Throwable)e);
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.close"), (Throwable)e);
        }
    }
}

