/*
 * Decompiled with CFR 0.152.
 */
package com.github.albfernandez.pmd.safenames;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class NamingConventionsRule
extends AbstractJavaRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        String classOrInterfaceName = node.getImage();
        if (!NamingConventionsRule.isValidIdentifier(classOrInterfaceName)) {
            this.addViolation(data, (Node)node, classOrInterfaceName);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        if (this.isOverriddenMethod(node)) {
            return super.visit(node, data);
        }
        String methodName = node.getImage();
        if (!NamingConventionsRule.isValidIdentifier(methodName)) {
            this.addViolation(data, (Node)node, methodName);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        this.checkVariableDeclarators((Node)node, data);
        return super.visit(node, data);
    }

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        this.checkVariableDeclarators((Node)node, data);
        return super.visit(node, data);
    }

    public Object visit(ASTFormalParameters node, Object data) {
        for (ASTFormalParameter formalParameter : node.findChildrenOfType(ASTFormalParameter.class)) {
            for (ASTVariableDeclaratorId variableDeclaratorId : formalParameter.findChildrenOfType(ASTVariableDeclaratorId.class)) {
                String variableName = variableDeclaratorId.getImage();
                if (NamingConventionsRule.isValidIdentifier(variableName)) continue;
                this.addViolation(data, (Node)variableDeclaratorId, variableName);
            }
        }
        return super.visit(node, data);
    }

    private Object checkVariableDeclarators(Node root, Object data) {
        for (ASTVariableDeclarator variableDeclarator : root.findChildrenOfType(ASTVariableDeclarator.class)) {
            for (ASTVariableDeclaratorId variableDeclaratorId : variableDeclarator.findChildrenOfType(ASTVariableDeclaratorId.class)) {
                String variableName = variableDeclaratorId.getImage();
                if (NamingConventionsRule.isValidIdentifier(variableName)) continue;
                this.addViolation(data, (Node)variableDeclaratorId, variableName);
            }
        }
        return data;
    }

    protected static boolean isValidIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if ("_".equals(name)) {
            return false;
        }
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            boolean valid;
            char c = name.charAt(i);
            boolean bl = valid = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
            if (valid) continue;
            return false;
        }
        return true;
    }

    private boolean isOverriddenMethod(ASTMethodDeclarator node) {
        ASTClassOrInterfaceBodyDeclaration declaration = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        List annotations = declaration.findDescendantsOfType(ASTMarkerAnnotation.class);
        for (ASTMarkerAnnotation ann : annotations) {
            ASTName name = (ASTName)ann.getFirstChildOfType(ASTName.class);
            if (name == null || !name.hasImageEqualTo("Override")) continue;
            return true;
        }
        return false;
    }
}

