/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.config;

import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.entity.DBConfig;
import com.github.alenfive.rocketapi.service.DataSourceService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@ConditionalOnProperty(value={"spring.rocket-api.datasource.check.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={DataSourceManager.class})
public class DataSourceCheckConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceCheckConfig.class);
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private DataSourceService dataSourceService;

    @Scheduled(initialDelayString="${spring.rocket-api.datasource.check.fixed-delay:PT1M}", fixedDelayString="${spring.rocket-api.datasource.check.fixed-delay:PT1M}")
    public void validate() {
        List<DBConfig> dbConfigList = this.dataSourceService.getDBConfig();
        Map<String, DataSourceDialect> dialectMap = this.dataSourceManager.getDialectMap();
        for (DBConfig config : dbConfigList) {
            DataSourceDialect dialect = dialectMap.get(config.getName());
            if (dialect != null) continue;
            try {
                this.dataSourceService.loadDBConfig(config);
            }
            catch (Exception e) {
                log.error("load db error:{}", (Object)config);
            }
        }
    }
}

