/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.datasource;

import com.github.alenfive.rocketapi.datasource.JdbcDataSource;
import com.github.alenfive.rocketapi.entity.vo.FieldInfo;
import com.github.alenfive.rocketapi.entity.vo.Page;
import com.github.alenfive.rocketapi.entity.vo.TableInfo;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.utils.SqlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.transaction.PlatformTransactionManager;

public class MySQLDataSource
extends JdbcDataSource {
    public MySQLDataSource() {
    }

    public MySQLDataSource(PlatformTransactionManager transactionManager) {
        super(transactionManager);
    }

    public MySQLDataSource(PlatformTransactionManager transactionManager, boolean storeApi) {
        super(transactionManager, storeApi);
    }

    @Override
    public String buildCountScript(String script, IApiPager apiPager, Page page) {
        return "select count(1) from (" + script + ") t1";
    }

    @Override
    public String buildPageScript(String script, IApiPager apiPager, Page page) {
        Integer offset = apiPager.getOffset(page.getPageSize(), page.getPageNo());
        return script + " limit " + offset + "," + page.getPageSize();
    }

    @Override
    public String transcoding(String param) {
        return param.replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'");
    }

    @Override
    public List<TableInfo> buildTableInfo() {
        try {
            ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
            List tables = this.jdbcTemplate.queryForList("show tables", Collections.EMPTY_MAP);
            for (Map table : tables) {
                Set keys = table.keySet();
                String tableName = table.get(keys.toArray(new String[0])[0]).toString();
                Map fields = this.jdbcTemplate.queryForMap("show create table " + tableName, Collections.EMPTY_MAP);
                if (fields.get("Create Table") == null) continue;
                String tableInfo = fields.get("Create Table").toString();
                String tableComment = SqlUtils.getByPattern(tableInfo, "\\) .* COMMENT='(.*)'", 1);
                ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
                tableInfos.add(TableInfo.builder().name(tableName).comment(tableComment).fields(fieldInfos).build());
                List<String> fieldStrList = SqlUtils.getColumnSqls(tableInfo);
                for (String oneLine : fieldStrList) {
                    String fieldName = SqlUtils.getByPattern(oneLine, "`(.*)`", 1);
                    String fieldComment = SqlUtils.getByPattern(oneLine, "COMMENT '(.*)'", 1);
                    String fieldType = SqlUtils.getByPattern(oneLine, "`" + fieldName + "` ([A-Za-z]*)", 1);
                    fieldInfos.add(FieldInfo.builder().name(fieldName).comment(fieldComment).type(fieldType).build());
                }
            }
            return tableInfos;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

