/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.extend;

import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.entity.ApiParams;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.service.ScriptParseService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DefaultApiPager
implements IApiPager {
    @Autowired
    private ScriptParseService parseService;
    @Autowired
    private RocketApiProperties rocketApiProperties;

    @Override
    public Object buildPager(Long totalRecords, List data, ApiInfo apiInfo, ApiParams apiParams) {
        HashMap<String, Object> pager = new HashMap<String, Object>();
        Integer pageNo = this.getPageNo();
        Integer pageSize = this.getPageSize();
        Integer offset = this.getOffset(pageSize, pageNo);
        pager.put(this.rocketApiProperties.getPager().getTotalRecordsVarName(), totalRecords);
        pager.put(this.rocketApiProperties.getPager().getTotalPagesVarName(), pageSize == null || pageNo == null || offset == null ? 0L : (totalRecords + (long)pageSize.intValue() - 1L) / (long)pageSize.intValue());
        pager.put(this.rocketApiProperties.getPager().getDataVarName(), data);
        pager.put(this.getPageNoVarName(), pageNo);
        pager.put(this.getPageSizeVarName(), pageSize);
        pager.put(this.getOffsetVarName(), offset);
        return pager;
    }

    @Override
    public String getPageSizeVarName() {
        return this.rocketApiProperties.getPager().getPageSizeVarName();
    }

    @Override
    public String getPageNoVarName() {
        return this.rocketApiProperties.getPager().getPageNoVarName();
    }

    @Override
    public String getOffsetVarName() {
        return this.rocketApiProperties.getPager().getOffsetVarName();
    }

    @Override
    public Integer getOffset(Integer pageSize, Integer pageNo) {
        return (pageNo - 1) * pageSize;
    }

    @Override
    public Integer getPageNo() {
        Object value = this.parseService.buildContentScopeParamItem(null, this.getPageNoVarName());
        if (StringUtils.isEmpty((Object)value)) {
            return this.rocketApiProperties.getPager().getDefaultPageNoValue();
        }
        return Integer.valueOf(value.toString());
    }

    @Override
    public Integer getPageSize() {
        Object value = this.parseService.buildContentScopeParamItem(null, this.getPageSizeVarName());
        if (StringUtils.isEmpty((Object)value)) {
            return this.rocketApiProperties.getPager().getDefaultPageSizeValue();
        }
        return Integer.valueOf(value.toString());
    }
}

