/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.function;

import com.github.alenfive.rocketapi.extend.IAssertException;
import com.github.alenfive.rocketapi.function.IFunction;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AssertFunction
implements IFunction {
    @Autowired
    private IAssertException assertException;

    @Override
    public String getVarName() {
        return "Assert";
    }

    public void isNotEmpty(Object input, String ... msg) {
        boolean validate;
        boolean bl = validate = !StringUtils.isEmpty((Object)input);
        if (!validate) {
            String throwMsg = msg.length > 0 ? msg[0] : "`" + input + "` is empty";
            this.assertException.exception(throwMsg, msg);
        }
    }

    public void isEmpty(Object input, String ... msg) {
        boolean validate = StringUtils.isEmpty((Object)input);
        if (!validate) {
            String throwMsg = msg.length > 0 ? msg[0] : "`" + input + "` is not empty";
            this.assertException.exception(throwMsg, msg);
        }
    }

    public void equals(Object input, Object input2, String ... msg) {
        boolean validate = Objects.equals(input, input2);
        if (!validate) {
            String throwMsg = msg.length > 0 ? msg[0] : "`" + input + "` is not equals";
            this.assertException.exception(throwMsg, msg);
        }
    }

    public void isTrue(boolean validate, String ... msg) {
        if (!validate) {
            String throwMsg = msg.length > 0 ? msg[0] : "input is false";
            this.assertException.exception(throwMsg, msg);
        }
    }

    public void regex(String regex, String input, String ... msg) {
        boolean validate;
        boolean bl = validate = input == null ? false : input.matches(regex);
        if (!validate) {
            String throwMsg = msg.length > 0 ? msg[0] : "`" + input + "`is not matches";
            this.assertException.exception(throwMsg, msg);
        }
    }
}

