/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.service;

import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.config.SysApiPager;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.entity.ApiDirectory;
import com.github.alenfive.rocketapi.entity.ApiEntity;
import com.github.alenfive.rocketapi.entity.ApiExample;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.entity.ApiInfoHistory;
import com.github.alenfive.rocketapi.entity.ApiType;
import com.github.alenfive.rocketapi.entity.vo.ExportReq;
import com.github.alenfive.rocketapi.entity.vo.ExportRes;
import com.github.alenfive.rocketapi.entity.vo.NewOldApiInfo;
import com.github.alenfive.rocketapi.entity.vo.NotifyEntity;
import com.github.alenfive.rocketapi.entity.vo.NotifyEventType;
import com.github.alenfive.rocketapi.entity.vo.Page;
import com.github.alenfive.rocketapi.entity.vo.RefreshMapping;
import com.github.alenfive.rocketapi.extend.IApiInfoCache;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.extend.IClusterNotify;
import com.github.alenfive.rocketapi.service.RequestMappingService;
import com.github.alenfive.rocketapi.utils.GenerateId;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ApiInfoService {
    @Autowired
    private IApiInfoCache apiInfoCache;
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private RequestMappingService requestMappingService;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    @Autowired
    @Lazy
    private IClusterNotify clusterNotify;
    private IApiPager apiPager = new SysApiPager();

    @Transactional
    public String saveApiInfo(ApiInfo apiInfo) throws Exception {
        ApiInfo oldMapping = null;
        if (!StringUtils.isEmpty((Object)apiInfo.getId())) {
            oldMapping = this.getApiInfoById(apiInfo.getId());
        }
        this.buildFullPath(apiInfo);
        this.assertExistsPattern(apiInfo);
        ApiInfo dbInfo = this.apiInfoCache.getAll().stream().filter(item -> item.getId().equals(apiInfo.getId())).findFirst().orElse(null);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        apiInfo.setUpdateTime(sdf.format(new Date()));
        if (dbInfo == null) {
            apiInfo.setType(ApiType.Ql.name());
            apiInfo.setCreateTime(sdf.format(new Date()));
            apiInfo.setService(this.rocketApiProperties.getServiceName());
            apiInfo.setId(GenerateId.get().toHexString());
            this.dataSourceManager.getStoreApiDataSource().saveEntity(apiInfo);
        } else {
            apiInfo.setType(dbInfo.getType());
            apiInfo.setCreateTime(dbInfo.getCreateTime());
            apiInfo.setService(dbInfo.getService());
            this.dataSourceManager.getStoreApiDataSource().updateEntityById(apiInfo);
            this.requestMappingService.unregisterMappingForApiInfo(dbInfo);
            this.apiInfoCache.remove(dbInfo);
        }
        dbInfo = this.dataSourceManager.getStoreApiDataSource().findEntityById(apiInfo);
        this.apiInfoCache.put(dbInfo);
        this.requestMappingService.registerMappingForApiInfo(dbInfo);
        this.saveApiHistory(dbInfo);
        this.sendNotify(oldMapping, dbInfo);
        return dbInfo.getId();
    }

    private void saveApiHistory(ApiInfo dbInfo) {
        ApiInfoHistory history = new ApiInfoHistory();
        BeanUtils.copyProperties((Object)dbInfo, (Object)history);
        history.setApiInfoId(dbInfo.getId());
        history.setId(GenerateId.get().toString());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        history.setCreateTime(sdf.format(new Date()));
        this.dataSourceManager.getStoreApiDataSource().saveEntity(history);
    }

    private List<ApiInfo> getConflictApiInfo(ApiInfo apiInfo) {
        return this.apiInfoCache.getAll().stream().filter(item -> item.getFullPath().equals(apiInfo.getFullPath()) && (item.getMethod().equals("All") || item.getMethod().equals(apiInfo.getMethod())) && !item.getId().equals(apiInfo.getId())).collect(Collectors.toList());
    }

    private void assertExistsPattern(ApiInfo apiInfo) {
        if (this.getConflictApiInfo(apiInfo).isEmpty() && !this.requestMappingService.isCodeMapping(apiInfo.getFullPath(), apiInfo.getMethod()).booleanValue()) {
            return;
        }
        throw new IllegalArgumentException("method: " + apiInfo.getMethod() + " path:" + apiInfo.getFullPath() + " already exist");
    }

    @Transactional
    public void deleteApiInfo(ApiInfo apiInfo) {
        ApiInfo dbInfo = this.getApiInfoById(apiInfo.getId());
        if (dbInfo == null) {
            return;
        }
        this.dataSourceManager.getStoreApiDataSource().removeEntityById(apiInfo);
        this.apiInfoCache.remove(dbInfo);
        this.requestMappingService.unregisterMappingForApiInfo(dbInfo);
        this.sendNotify(dbInfo, null);
    }

    @Transactional
    public Object saveExample(ApiExample apiExample) {
        this.dataSourceManager.getStoreApiDataSource().saveEntity(apiExample);
        return apiExample.getId();
    }

    public List<ApiExample> listApiExampleScript(String apiInfoId, Integer pageSize, Integer pageNo) {
        Page page = Page.builder().pageNo(pageNo).pageSize(pageSize).build();
        return this.dataSourceManager.getStoreApiDataSource().pageByEntity(ApiExample.builder().apiInfoId(apiInfoId).build(), this.apiPager, page);
    }

    @Transactional
    public void deleteExampleList(ArrayList<ApiExample> apiExampleList) {
        apiExampleList.stream().forEach(item -> this.dataSourceManager.getStoreApiDataSource().removeEntityById(item));
    }

    public List<ApiInfoHistory> lastApiInfo(String apiInfoId, Integer pageSize, Integer pageNo) {
        Page page = Page.builder().pageNo(pageNo).pageSize(pageSize).build();
        return this.dataSourceManager.getStoreApiDataSource().pageByEntity(ApiInfoHistory.builder().apiInfoId(apiInfoId).service(this.rocketApiProperties.getServiceName()).build(), this.apiPager, page);
    }

    @Transactional(rollbackFor={Exception.class})
    public Object importAPI(Collection<ApiDirectory> directories, Collection<ApiInfo> apiInfos, Boolean override) throws Exception {
        Collection<ApiInfo> currApiInfos = this.getPathList(false);
        List<ApiDirectory> currDirectories = this.loadDirectoryList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (ApiDirectory directory : directories) {
            ApiDirectory dbDirectory = currDirectories.stream().filter(item -> item.getId().equals(directory.getId())).findFirst().orElse(null);
            if (dbDirectory == null) {
                this.dataSourceManager.getStoreApiDataSource().saveEntity(directory);
                continue;
            }
            this.dataSourceManager.getStoreApiDataSource().updateEntityById(directory);
        }
        for (ApiInfo apiInfo : apiInfos) {
            ApiInfo dbInfo = currApiInfos.stream().filter(item -> item.getId().equals(apiInfo.getId())).findFirst().orElse(null);
            if (dbInfo == null) {
                if (override.booleanValue()) {
                    this.getConflictApiInfo(apiInfo).forEach(this::deleteApiInfo);
                } else {
                    this.assertExistsPattern(apiInfo);
                }
                apiInfo.setCreateTime(sdf.format(new Date()));
                apiInfo.setUpdateTime(sdf.format(new Date()));
                this.dataSourceManager.getStoreApiDataSource().saveEntity(apiInfo);
            } else {
                apiInfo.setUpdateTime(sdf.format(new Date()));
                this.dataSourceManager.getStoreApiDataSource().updateEntityById(apiInfo);
            }
            this.saveApiHistory(apiInfo);
        }
        this.reLoadApiInfo(false);
        return apiInfos.size();
    }

    @Transactional(rollbackFor={Exception.class})
    public Object apiInfoSync(Collection<ApiDirectory> directories, Collection<ApiInfo> apiInfos, Boolean increment) throws Exception {
        if (CollectionUtils.isEmpty(apiInfos)) {
            return 0;
        }
        Collection<ApiInfo> currApiInfos = this.getPathList(false);
        List<ApiDirectory> currDirectories = this.loadDirectoryList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!increment.booleanValue()) {
            for (ApiDirectory dbDirectory : currDirectories) {
                this.dataSourceManager.getStoreApiDataSource().removeEntityById(dbDirectory);
            }
            for (ApiDirectory directory : directories) {
                this.dataSourceManager.getStoreApiDataSource().saveEntity(directory);
            }
            for (ApiInfo dbInfo : currApiInfos) {
                this.deleteApiInfo(dbInfo);
            }
            for (ApiInfo apiInfo : apiInfos) {
                apiInfo.setCreateTime(sdf.format(new Date()));
                apiInfo.setUpdateTime(sdf.format(new Date()));
                this.dataSourceManager.getStoreApiDataSource().saveEntity(apiInfo);
                this.saveApiHistory(apiInfo);
            }
        } else {
            for (ApiDirectory directory : directories) {
                ApiDirectory dbDirectory = currDirectories.stream().filter(item -> item.getId().equals(directory.getId())).findFirst().orElse(null);
                if (dbDirectory == null) {
                    this.dataSourceManager.getStoreApiDataSource().saveEntity(directory);
                    continue;
                }
                this.dataSourceManager.getStoreApiDataSource().updateEntityById(directory);
            }
            for (ApiInfo apiInfo : apiInfos) {
                ApiInfo dbInfo = currApiInfos.stream().filter(item -> item.getId().equals(apiInfo.getId())).findFirst().orElse(null);
                if (dbInfo == null) {
                    this.assertExistsPattern(apiInfo);
                    apiInfo.setCreateTime(sdf.format(new Date()));
                    apiInfo.setUpdateTime(sdf.format(new Date()));
                    this.dataSourceManager.getStoreApiDataSource().saveEntity(apiInfo);
                } else {
                    apiInfo.setUpdateTime(sdf.format(new Date()));
                    this.dataSourceManager.getStoreApiDataSource().updateEntityById(apiInfo);
                }
                this.saveApiHistory(apiInfo);
            }
        }
        this.reLoadApiInfo(false);
        return apiInfos.size();
    }

    public List<ApiDirectory> loadDirectoryList() {
        List<ApiDirectory> directoryList = this.dataSourceManager.getStoreApiDataSource().listByEntity(ApiDirectory.builder().service(this.rocketApiProperties.getServiceName()).build());
        if (directoryList.isEmpty()) {
            try {
                this.saveDirectory(ApiDirectory.builder().name("\u9ed8\u8ba4\u7ec4").service(this.rocketApiProperties.getServiceName()).path("").build());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            directoryList = this.dataSourceManager.getStoreApiDataSource().listByEntity(ApiDirectory.builder().service(this.rocketApiProperties.getServiceName()).build());
        }
        return directoryList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeDirectory(ApiDirectory directory) {
        List<ApiDirectory> directoryList = this.loadDirectoryList();
        Set<String> directoryIds = this.findChildrenIds(directoryList, directory.getId());
        directoryIds.add(directory.getId());
        for (String directoryId : directoryIds) {
            ApiDirectory dir = new ApiDirectory();
            dir.setId(directoryId);
            this.dataSourceManager.getStoreApiDataSource().removeEntityById(dir);
            List apiInfoList = this.apiInfoCache.getAll().stream().filter(item -> directoryId.equals(item.getDirectoryId())).collect(Collectors.toList());
            for (ApiInfo apiInfo : apiInfoList) {
                this.deleteApiInfo(apiInfo);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveDirectory(ApiDirectory directory) throws Exception {
        directory.setService(this.rocketApiProperties.getServiceName());
        if (StringUtils.isEmpty((Object)directory.getId())) {
            directory.setId(GenerateId.get().toHexString());
            this.dataSourceManager.getStoreApiDataSource().saveEntity(directory);
            return;
        }
        ApiDirectory dbDirectory = this.dataSourceManager.getStoreApiDataSource().findEntityById(directory);
        this.dataSourceManager.getStoreApiDataSource().updateEntityById(directory);
        if (Objects.equals(dbDirectory.getPath(), directory.getPath())) {
            return;
        }
        List<ApiDirectory> directoryList = this.loadDirectoryList();
        Set<String> directoryIds = this.findChildrenIds(directoryList, directory.getId());
        directoryIds.add(directory.getId());
        List<ApiInfo> modifyApiInfos = this.apiInfoCache.getAll().stream().filter(item -> directoryIds.contains(item.getDirectoryId()) && ApiType.Ql.name().equals(item.getType())).collect(Collectors.toList());
        modifyApiInfos.forEach(item -> {
            ApiInfo newApiInfo = new ApiInfo();
            BeanUtils.copyProperties((Object)item, (Object)newApiInfo);
            this.buildFullPath(newApiInfo);
            this.assertExistsPattern(newApiInfo);
            this.dataSourceManager.getStoreApiDataSource().updateEntityById(newApiInfo);
        });
        for (ApiInfo item2 : modifyApiInfos) {
            this.requestMappingService.unregisterMappingForApiInfo(item2);
            this.apiInfoCache.remove(item2);
            ApiInfo dbInfo = this.dataSourceManager.getStoreApiDataSource().findEntityById(item2);
            this.apiInfoCache.put(dbInfo);
            this.requestMappingService.registerMappingForApiInfo(dbInfo);
            this.saveApiHistory(dbInfo);
            this.sendNotify(item2, dbInfo);
        }
    }

    private String formatPath(StringBuilder path) {
        path.insert(0, "/");
        String result = path.toString().replaceAll("/+", "/");
        if (result.length() > 1 && result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void buildFullPath(ApiInfo apiInfo) {
        StringBuilder path = new StringBuilder(apiInfo.getPath());
        this.recursiveFullPath(this.loadDirectoryList(), apiInfo.getDirectoryId(), path);
        apiInfo.setFullPath(this.formatPath(path));
    }

    private void recursiveFullPath(List<ApiDirectory> directoryList, String directoryId, StringBuilder path) {
        ApiDirectory directory = directoryList.stream().filter(item -> item.getId().equals(directoryId)).findFirst().orElse(null);
        if (!StringUtils.isEmpty((Object)directory.getPath())) {
            path.insert(0, "/");
            path.insert(0, directory.getPath());
        }
        if (StringUtils.isEmpty((Object)directory.getParentId())) {
            return;
        }
        this.recursiveFullPath(directoryList, directory.getParentId(), path);
    }

    public void relationParentDirectory(Set<ApiDirectory> directorySet, List<ApiDirectory> directoryList, ApiDirectory directory) {
        directorySet.add(directory);
        for (ApiDirectory item : directoryList) {
            if (!item.getId().equals(directory.getParentId())) continue;
            directorySet.add(directory);
            this.relationParentDirectory(directorySet, directoryList, item);
        }
    }

    private Set<String> findChildrenIds(List<ApiDirectory> directoryList, String directoryId) {
        Set<String> result = directoryList.stream().filter(item -> directoryId.equals(item.getParentId())).map(ApiEntity::getId).collect(Collectors.toSet());
        for (String item2 : result) {
            result.addAll(this.findChildrenIds(directoryList, item2));
        }
        return result;
    }

    private ApiInfo getApiInfoByMapping(String fullPath, String method) {
        return this.apiInfoCache.getAll().stream().filter(item -> item.getFullPath().equals(fullPath) && (item.getMethod().equals("All") || item.getMethod().equals(method))).findAny().orElse(null);
    }

    public ApiInfo getApiInfoById(String id) {
        return this.apiInfoCache.getAll().stream().filter(item -> item.getId().equals(id)).findFirst().orElse(null);
    }

    public void reLoadApiInfo(Boolean isStart) throws NoSuchMethodException {
        List<ApiInfo> dbApiInfoList = this.dataSourceManager.getStoreApiDataSource().listByEntity(ApiInfo.builder().service(this.rocketApiProperties.getServiceName()).build());
        List newOldApiInfoList = dbApiInfoList.stream().map(item -> NewOldApiInfo.builder().apiInfoId(item.getId()).newApiInfo((ApiInfo)item).build()).collect(Collectors.toList());
        Collection<ApiInfo> cacheApiInfoList = this.apiInfoCache.getAll();
        cacheApiInfoList.forEach(cacheItem -> {
            NewOldApiInfo newOldApiInfo = newOldApiInfoList.stream().filter(dbItem -> dbItem.getApiInfoId().equals(cacheItem.getId())).findFirst().orElse(null);
            if (newOldApiInfo != null) {
                newOldApiInfo.setOldApiInfo((ApiInfo)cacheItem);
            } else {
                newOldApiInfo = NewOldApiInfo.builder().apiInfoId(cacheItem.getId()).oldApiInfo((ApiInfo)cacheItem).build();
                newOldApiInfoList.add(newOldApiInfo);
            }
        });
        for (NewOldApiInfo item2 : newOldApiInfoList) {
            if (item2.getOldApiInfo() != null) {
                this.requestMappingService.unregisterMappingForApiInfo(item2.getOldApiInfo());
                this.apiInfoCache.remove(item2.getOldApiInfo());
            }
            if (item2.getNewApiInfo() != null) {
                this.requestMappingService.registerMappingForApiInfo(item2.getNewApiInfo());
                this.apiInfoCache.put(item2.getNewApiInfo());
            }
            if (isStart.booleanValue()) continue;
            this.sendNotify(item2.getOldApiInfo(), item2.getNewApiInfo());
        }
    }

    public void sendNotify(ApiInfo oldMapping, ApiInfo newMapping) {
        RefreshMapping refreshMapping = RefreshMapping.builder().oldMapping(oldMapping).newMapping(newMapping).build();
        this.clusterNotify.sendNotify(NotifyEntity.builder().eventType(NotifyEventType.RefreshMapping).refreshMapping(refreshMapping).build());
    }

    public Collection<ApiInfo> getPathList(boolean isDb) throws Exception {
        if (isDb) {
            this.reLoadApiInfo(false);
        }
        return this.apiInfoCache.getAll();
    }

    public ExportRes exportApi(ExportReq exportReq) throws Exception {
        List<String> apiInfoIds = Arrays.asList(exportReq.getApiInfoIds().split(","));
        Collection apiInfos = null;
        List<ApiDirectory> directories = this.loadDirectoryList();
        apiInfos = this.getPathList(false).stream().filter(item -> apiInfoIds.contains(item.getId())).collect(Collectors.toList());
        HashSet<ApiDirectory> directorySet = new HashSet<ApiDirectory>();
        for (ApiInfo apiInfo : apiInfos) {
            ApiDirectory directory = directories.stream().filter(item -> item.getId().equals(apiInfo.getDirectoryId())).findFirst().orElse(null);
            this.relationParentDirectory(directorySet, directories, directory);
        }
        return ExportRes.builder().apiInfos(apiInfos).directories(directorySet).build();
    }

    public void refreshMapping(RefreshMapping refreshMapping) throws NoSuchMethodException {
        if (refreshMapping.getOldMapping() != null) {
            this.requestMappingService.unregisterMappingForApiInfo(refreshMapping.getOldMapping());
            this.apiInfoCache.remove(refreshMapping.getOldMapping());
        }
        if (refreshMapping.getNewMapping() != null) {
            this.requestMappingService.registerMappingForApiInfo(refreshMapping.getNewMapping());
            this.apiInfoCache.put(refreshMapping.getNewMapping());
        }
    }
}

