/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.service;

import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.datasource.factory.IDataSourceDialectDriver;
import com.github.alenfive.rocketapi.entity.vo.CompletionResult;
import com.github.alenfive.rocketapi.entity.vo.MethodVo;
import com.github.alenfive.rocketapi.entity.vo.TableInfo;
import com.github.alenfive.rocketapi.function.IFunction;
import com.github.alenfive.rocketapi.utils.PackageUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CompletionService {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private DataSourceManager dataSourceManager;
    private Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    public CompletionResult provideCompletionTypes() throws Exception {
        String cacheKey = "completion-items-cache";
        CompletionResult result = null;
        result = (CompletionResult)this.cache.get(cacheKey);
        if (result != null) {
            return result;
        }
        result = new CompletionResult();
        LinkedHashMap<String, List<MethodVo>> clazzs = new LinkedHashMap<String, List<MethodVo>>();
        HashMap<String, String> variables = new HashMap<String, String>();
        HashMap<String, String> syntax = new HashMap<String, String>();
        HashMap<String, List<TableInfo>> dbInfos = new HashMap<String, List<TableInfo>>();
        result.setClazzs(clazzs);
        result.setVariables(variables);
        result.setSyntax(syntax);
        result.setDbInfos(dbInfos);
        Collection functionList = this.context.getBeansOfType(IFunction.class).values();
        functionList.forEach(item -> variables.put(item.getVarName(), item.getClass().getName()));
        Map beans = this.context.getBeansOfType(Object.class);
        for (Object key2 : beans.keySet()) {
            this.buildClazz(clazzs, beans.get(key2).getClass());
        }
        List<Class> classList = PackageUtil.loadClassByLoader(Thread.currentThread().getContextClassLoader());
        for (Class clazz : classList) {
            this.buildClazz(clazzs, clazz);
        }
        List<String> classNames = PackageUtil.scan();
        for (String clazz : classNames) {
            this.buildClazz(clazzs, clazz);
        }
        syntax.put("foreach", "for(item in ${1:collection}){\n\t\n}");
        syntax.put("fori", "for(${1:i}=0;${1:i}<;${1:i}++){\n\t\n}");
        syntax.put("for", "for(${1}){\n\t\n}");
        syntax.put("if", "if(${1:condition}){\n\n}");
        syntax.put("ifelse", "if(${1:condition}){\n\t\n}else{\n\t\n}");
        syntax.put("import", "import ");
        syntax.put("continue", "continue;");
        syntax.put("break", "break;");
        Map<String, DataSourceDialect> map = this.dataSourceManager.getDialectMap();
        map.forEach((key, value) -> {
            List<TableInfo> tableInfos = value.buildTableInfo();
            if (tableInfos != null) {
                dbInfos.put((String)key, tableInfos);
            }
        });
        this.cache.put(cacheKey, result);
        return result;
    }

    private void buildClazz(Map<String, List<MethodVo>> clazzs, String clazz) {
        if (clazzs.get(clazz) != null || clazz.indexOf("$") != -1) {
            return;
        }
        clazzs.put(clazz, Collections.EMPTY_LIST);
    }

    private void buildClazz(Map<String, List<MethodVo>> clazzs, Class clazz) {
        if (clazzs.get(clazz.getName()) != null || clazz.getName().indexOf("$") != -1) {
            return;
        }
        clazzs.put(clazz.getName(), this.buildMethod(clazz));
    }

    public List<MethodVo> buildMethod(Class clazz) {
        ArrayList<MethodVo> methodVos = new ArrayList<MethodVo>();
        for (Field field : clazz.getFields()) {
            methodVos.add(MethodVo.builder().type("field").varName(field.getName()).resultType(field.getType().getName()).build());
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            boolean isStatic = Modifier.isStatic(((Method)accessibleObject).getModifiers());
            String params = Stream.of(((Executable)accessibleObject).getParameters()).map(item -> item.getType().getSimpleName() + " " + item.getName()).collect(Collectors.joining(","));
            methodVos.add(MethodVo.builder().type(isStatic ? "static" : "public").varName(((Method)accessibleObject).getName()).params(params).resultType(((Method)accessibleObject).getReturnType().getName()).build());
        }
        return methodVos;
    }

    public Collection<IDataSourceDialectDriver> getDriver() {
        return this.context.getBeansOfType(IDataSourceDialectDriver.class).values();
    }
}

