/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.service;

import com.github.alenfive.rocketapi.config.RefreshApiConfig;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.entity.ApiConfig;
import com.github.alenfive.rocketapi.entity.ConfigType;
import com.github.alenfive.rocketapi.entity.vo.NotifyEntity;
import com.github.alenfive.rocketapi.entity.vo.NotifyEventType;
import com.github.alenfive.rocketapi.extend.IClusterNotify;
import com.github.alenfive.rocketapi.utils.GenerateId;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ConfigService {
    @Autowired(required=false)
    private RefreshApiConfig refreshApiConfig;
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    @Autowired
    @Lazy
    private IClusterNotify clusterNotify;

    public void reloadApiConfig(Boolean isStart) {
        this.refreshConfig();
        if (!isStart.booleanValue()) {
            this.clusterNotify.sendNotify(NotifyEntity.builder().eventType(NotifyEventType.RefreshConfig).build());
        }
    }

    public void saveYmlConfig(String configContext) throws Exception {
        ApiConfig apiConfig = this.getYmlConfig();
        if (apiConfig == null) {
            apiConfig = ApiConfig.builder().configContext(configContext).type(ConfigType.Yml.name()).service(this.rocketApiProperties.getServiceName()).build();
            apiConfig.setId(GenerateId.get().toHexString());
            this.dataSourceManager.getStoreApiDataSource().saveEntity(apiConfig);
        } else {
            apiConfig.setConfigContext(configContext);
            this.dataSourceManager.getStoreApiDataSource().updateEntityById(apiConfig);
        }
        this.reloadApiConfig(false);
    }

    public ApiConfig getConfigById(String id) {
        ApiConfig apiConfig = new ApiConfig();
        apiConfig.setId(id);
        return this.dataSourceManager.getStoreApiDataSource().findEntityById(apiConfig);
    }

    public void removeConfigById(String id) {
        ApiConfig apiConfig = new ApiConfig();
        apiConfig.setId(id);
        this.dataSourceManager.getStoreApiDataSource().removeEntityById(apiConfig);
    }

    public ApiConfig getYmlConfig() {
        List<ApiConfig> list = this.dataSourceManager.getStoreApiDataSource().listByEntity(ApiConfig.builder().service(this.rocketApiProperties.getServiceName()).type(ConfigType.Yml.name()).build());
        return list.stream().findFirst().orElse(null);
    }

    public void refreshConfig() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        String apiConfigName = "applicationConfig:[db:/rocket-api.yml]";
        if (!this.rocketApiProperties.isConfigEnabled()) {
            propertySources.remove(apiConfigName);
            return;
        }
        ApiConfig apiConfig = this.getYmlConfig();
        YamlPropertiesFactoryBean factoryBean = new YamlPropertiesFactoryBean();
        if (apiConfig != null && !StringUtils.isEmpty((Object)apiConfig.getConfigContext())) {
            factoryBean.setResources(new Resource[]{new ByteArrayResource(apiConfig.getConfigContext().getBytes())});
        }
        Properties properties = factoryBean.getObject();
        PropertiesPropertySource constants = new PropertiesPropertySource(apiConfigName, properties);
        Pattern p = Pattern.compile("^applicationConfig.*");
        String name = null;
        boolean exists = propertySources.contains(apiConfigName);
        if (exists) {
            name = apiConfigName;
        } else {
            for (PropertySource source : propertySources) {
                if (!p.matcher(source.getName()).matches()) continue;
                name = source.getName();
                break;
            }
        }
        if (exists) {
            propertySources.replace(name, (PropertySource)constants);
        } else if (name != null) {
            propertySources.addBefore(name, (PropertySource)constants);
        } else {
            propertySources.addFirst((PropertySource)constants);
        }
        if (this.refreshApiConfig != null) {
            this.refreshApiConfig.refresh();
        }
    }
}

