/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.service;

import com.github.alenfive.rocketapi.config.QLRequestMappingFactory;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.entity.ApiType;
import com.github.alenfive.rocketapi.utils.MappingInfoUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Service
public class RequestMappingService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RequestMappingService.class);
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    private RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();
    @Autowired
    @Lazy
    private QLRequestMappingFactory mappingFactory;

    public List<ApiInfo> getPathListForCode() {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        ArrayList<ApiInfo> result = new ArrayList<ApiInfo>(map.size());
        for (RequestMappingInfo info : map.keySet()) {
            if (((HandlerMethod)map.get(info)).getMethod().getDeclaringClass() == QLRequestMappingFactory.class) continue;
            String groupName = ((HandlerMethod)map.get(info)).getBeanType().getSimpleName();
            for (String path : MappingInfoUtils.getPatterns(info)) {
                if (path.indexOf(this.rocketApiProperties.getBaseRegisterPath()) == 0 || path.equals("/error")) continue;
                Set methods = info.getMethodsCondition().getMethods();
                if (methods.isEmpty()) {
                    result.add(ApiInfo.builder().path(path).fullPath(path).method("All").type(ApiType.Code.name()).service(this.rocketApiProperties.getServiceName()).directoryId(groupName).editor("admin").name("").datasource("").script("").options("").build());
                    continue;
                }
                for (RequestMethod method : methods) {
                    result.add(ApiInfo.builder().path(path).fullPath(path).method(method.name()).type(ApiType.Code.name()).service(this.rocketApiProperties.getServiceName()).directoryId(groupName).editor("admin").name("").datasource("").script("").options("").build());
                }
            }
        }
        return result;
    }

    public synchronized void registerMappingForApiInfo(ApiInfo apiInfo) throws NoSuchMethodException {
        if (ApiType.Code.name().equals(apiInfo.getType())) {
            return;
        }
        String pattern = apiInfo.getFullPath();
        if (StringUtils.isEmpty((Object)pattern) || pattern.startsWith("TEMP-")) {
            return;
        }
        RequestMappingInfo mappingInfo = this.getRequestMappingInfo(pattern, apiInfo.getMethod());
        if (mappingInfo != null) {
            return;
        }
        log.debug("Mapped [{}]{}", (Object)apiInfo.getMethod(), (Object)pattern);
        mappingInfo = RequestMappingInfo.paths((String[])new String[]{pattern}).methods(new RequestMethod[]{RequestMethod.valueOf((String)apiInfo.getMethod())}).options(this.config).build();
        Method targetMethod = QLRequestMappingFactory.class.getDeclaredMethod("execute", Map.class, Map.class, HttpServletRequest.class, HttpServletResponse.class);
        this.requestMappingHandlerMapping.registerMapping(mappingInfo, (Object)this.mappingFactory, targetMethod);
    }

    public synchronized void unregisterMappingForApiInfo(ApiInfo apiInfo) {
        if (ApiType.Code.name().equals(apiInfo.getType())) {
            return;
        }
        String pattern = apiInfo.getFullPath();
        if (StringUtils.isEmpty((Object)pattern) || pattern.startsWith("TEMP-")) {
            return;
        }
        RequestMappingInfo mappingInfo = this.getRequestMappingInfo(pattern, apiInfo.getMethod());
        if (mappingInfo == null) {
            return;
        }
        log.debug("Cancel Mapping [{}]{}", (Object)apiInfo.getMethod(), (Object)pattern);
        mappingInfo = RequestMappingInfo.paths((String[])new String[]{pattern}).methods(new RequestMethod[]{RequestMethod.valueOf((String)apiInfo.getMethod())}).options(this.config).build();
        this.requestMappingHandlerMapping.unregisterMapping((Object)mappingInfo);
    }

    private RequestMappingInfo getRequestMappingInfo(String pattern, String method) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        for (RequestMappingInfo info : map.keySet()) {
            Set<String> patterns = MappingInfoUtils.getPatterns(info);
            Set methods = info.getMethodsCondition().getMethods();
            if (!patterns.contains(pattern) || !methods.isEmpty() && !methods.contains(RequestMethod.valueOf((String)method))) continue;
            return info;
        }
        return null;
    }

    public Boolean isCodeMapping(String pattern, String method) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        for (RequestMappingInfo info : map.keySet()) {
            if (((HandlerMethod)map.get(info)).getMethod().getDeclaringClass() == QLRequestMappingFactory.class) continue;
            Set<String> patterns = MappingInfoUtils.getPatterns(info);
            Set methods = info.getMethodsCondition().getMethods();
            if (!patterns.contains(pattern) || !methods.isEmpty() && !methods.contains(RequestMethod.valueOf((String)method))) continue;
            return true;
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        this.config.setTrailingSlashMatch(this.requestMappingHandlerMapping.useTrailingSlashMatch());
        this.config.setContentNegotiationManager(this.requestMappingHandlerMapping.getContentNegotiationManager());
        if (this.requestMappingHandlerMapping.getPatternParser() != null) {
            this.config.setPatternParser(this.requestMappingHandlerMapping.getPatternParser());
            Assert.isTrue((!this.requestMappingHandlerMapping.useSuffixPatternMatch() && !this.requestMappingHandlerMapping.useRegisteredSuffixPatternMatch() ? 1 : 0) != 0, (String)"Suffix pattern matching not supported with PathPatternParser.");
        } else {
            this.config.setSuffixPatternMatch(this.requestMappingHandlerMapping.useSuffixPatternMatch());
            this.config.setRegisteredSuffixPatternMatch(this.requestMappingHandlerMapping.useRegisteredSuffixPatternMatch());
            this.config.setPathMatcher(this.requestMappingHandlerMapping.getPathMatcher());
        }
    }
}

