/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.HandlerMapping;

public class RequestUtils {
    public static String buildPattern(HttpServletRequest request) {
        return (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
    }

    public static Map<String, Object> buildSessionParams(HttpServletRequest request) {
        Enumeration keys = request.getSession().getAttributeNames();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            result.put(key, request.getSession().getAttribute(key));
        }
        return result;
    }

    public static Map<String, String> buildHeaderParams(HttpServletRequest request) throws UnsupportedEncodingException {
        Enumeration headerKeys = request.getHeaderNames();
        HashMap<String, String> result = new HashMap<String, String>();
        while (headerKeys.hasMoreElements()) {
            String key = (String)headerKeys.nextElement();
            String value = request.getHeader(key);
            result.put(key, value);
        }
        return result;
    }
}

