/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator;

import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.io.GqlReader;
import com.github.alme.graphql.generator.io.GqlWriter;
import com.github.alme.graphql.generator.io.ReaderFactory;
import com.github.alme.graphql.generator.io.WriterFactory;
import com.github.alme.graphql.generator.parameters.AliasMapParameterApplier;
import com.github.alme.graphql.generator.parameters.DataObjectEnhancementTypeParameterApplier;
import com.github.alme.graphql.generator.parameters.FieldTransformationApplier;
import com.github.alme.graphql.generator.parameters.GeneratedAnnotationParameterApplier;
import com.github.alme.graphql.generator.parameters.OutputDirectoryParameterApplier;
import com.github.alme.graphql.generator.parameters.OutputTypesParameterApplier;
import com.github.alme.graphql.generator.parameters.ParserOptionsParameterApplier;
import com.github.alme.graphql.generator.parameters.ScalarMapParameterApplier;
import com.github.alme.graphql.generator.parameters.SourceParameterApplier;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresProject=false)
public class GeneratorMojo
extends AbstractMojo {
    @Parameter
    private FileSet source;
    @Parameter(property="gql.sourceDirectory")
    private String sourceDirectoryAlternative;
    @Parameter(property="gql.sourceIncludes")
    private Set<String> sourceIncludesAlternative;
    @Parameter(property="gql.sourceExcludes")
    private Set<String> sourceExcludesAlternative;
    @Parameter(property="gql.outputDirectory")
    private File outputDirectory;
    @Parameter(property="gql.packageName", defaultValue="gql.generated")
    private String packageName;
    @Parameter
    private Map<String, String> scalarMap;
    @Parameter(property="gql.scalarMap")
    private Set<String> scalarMapAlternative;
    @Parameter
    private Map<String, String> aliasMap;
    @Parameter(property="gql.aliasMap")
    private Set<String> aliasMapAlternative;
    @Parameter(property="gql.importPackages")
    private Set<String> importPackages;
    @Parameter(property="gql.jsonPropertyAnnotation")
    private String jsonPropertyAnnotation;
    @Parameter(property="gql.privateFieldPrefix")
    private String privateFieldPrefix;
    @Parameter(property="gql.privateFieldSuffix")
    private String privateFieldSuffix;
    @Parameter(property="gql.generatedAnnotationVersion")
    private String generatedAnnotationVersion;
    @Parameter(property="gql.dataObjectEnhancement")
    private GqlConfiguration.DataObjectEnhancementType dataObjectEnhancement;
    @Parameter(property="gql.generatedOutputTypes")
    private Set<GqlConfiguration.GeneratedOutputType> generatedOutputTypes;
    @Parameter(property="gql.parserMaxTokens")
    private Integer parserMaxTokens;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        GqlConfiguration configuration = GqlConfiguration.builder().accept(new SourceParameterApplier(this.project, this.source, this.sourceDirectoryAlternative, this.sourceIncludesAlternative, this.sourceExcludesAlternative)).accept(new OutputDirectoryParameterApplier(this.project, this.outputDirectory, this.packageName)).accept(new ScalarMapParameterApplier(this.scalarMap, this.scalarMapAlternative)).accept(new AliasMapParameterApplier(this.aliasMap, this.aliasMapAlternative)).accept(new DataObjectEnhancementTypeParameterApplier(this.dataObjectEnhancement)).accept(new OutputTypesParameterApplier(this.generatedOutputTypes)).accept(new GeneratedAnnotationParameterApplier(this.generatedAnnotationVersion)).accept(new ParserOptionsParameterApplier(this.parserMaxTokens)).accept(new FieldTransformationApplier(this.jsonPropertyAnnotation, this.privateFieldPrefix, this.privateFieldSuffix)).importPackages(this.importPackages).build();
        this.getLog().info((CharSequence)String.format("Current configuration: %s.", configuration));
        GqlContext context = new GqlContext(this.getLog(), configuration.getScalars(), configuration.getAliases());
        ReaderFactory readerFactory = new ReaderFactory(configuration.getSourceFiles(), this.getLog());
        WriterFactory writerFactory = new WriterFactory();
        new GqlReader(readerFactory).read(context, configuration);
        this.getLog().debug((CharSequence)String.format("Current context: %s.", context));
        new GqlWriter(writerFactory).write(context, configuration);
        this.getLog().info((CharSequence)"Generation is done.");
        String outputRoot = configuration.getOutputRoot().toString();
        this.project.addCompileSourceRoot(outputRoot);
        this.project.addTestCompileSourceRoot(outputRoot);
    }
}

