/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

import com.github.alme.graphql.generator.parameters.ParameterApplier;
import graphql.parser.ParserOptions;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public final class GqlConfiguration {
    private final Collection<Path> sourceFiles;
    private final Set<String> importPackages;
    private final Map<String, String> scalars;
    private final Map<String, String> aliases;
    private final boolean generateDtoMethodChaining;
    private final boolean generateDtoBuilder;
    private final boolean generateDtoSetters;
    private final boolean generateDtoConstructor;
    private final boolean generateDefinedOperations;
    private final boolean generateDynamicOperations;
    private final boolean generateSchemaInputTypes;
    private final boolean generateSchemaOtherTypes;
    private final String jsonPropertyAnnotation;
    private final String jsonPropertyPrefix;
    private final String jsonPropertySuffix;
    private final String generatedAnnotation;
    private final String schemaTypesPackageName;
    private final String operationsPackageName;
    private final String resultsPackageName;
    private final String selectorsPackageName;
    private final Path outputRoot;
    private final Path schemaTypesPackagePath;
    private final Path operationsPackagePath;
    private final Path resultsPackagePath;
    private final Path selectorsPackagePath;
    private final ParserOptions parserOptions;

    GqlConfiguration(Collection<Path> sourceFiles, Set<String> importPackages, Map<String, String> scalars, Map<String, String> aliases, boolean generateDtoMethodChaining, boolean generateDtoBuilder, boolean generateDtoSetters, boolean generateDtoConstructor, boolean generateDefinedOperations, boolean generateDynamicOperations, boolean generateSchemaInputTypes, boolean generateSchemaOtherTypes, String jsonPropertyAnnotation, String jsonPropertyPrefix, String jsonPropertySuffix, String generatedAnnotation, String schemaTypesPackageName, String operationsPackageName, String resultsPackageName, String selectorsPackageName, Path outputRoot, Path schemaTypesPackagePath, Path operationsPackagePath, Path resultsPackagePath, Path selectorsPackagePath, ParserOptions parserOptions) {
        this.sourceFiles = sourceFiles;
        this.importPackages = importPackages;
        this.scalars = scalars;
        this.aliases = aliases;
        this.generateDtoMethodChaining = generateDtoMethodChaining;
        this.generateDtoBuilder = generateDtoBuilder;
        this.generateDtoSetters = generateDtoSetters;
        this.generateDtoConstructor = generateDtoConstructor;
        this.generateDefinedOperations = generateDefinedOperations;
        this.generateDynamicOperations = generateDynamicOperations;
        this.generateSchemaInputTypes = generateSchemaInputTypes;
        this.generateSchemaOtherTypes = generateSchemaOtherTypes;
        this.jsonPropertyAnnotation = jsonPropertyAnnotation;
        this.jsonPropertyPrefix = jsonPropertyPrefix;
        this.jsonPropertySuffix = jsonPropertySuffix;
        this.generatedAnnotation = generatedAnnotation;
        this.schemaTypesPackageName = schemaTypesPackageName;
        this.operationsPackageName = operationsPackageName;
        this.resultsPackageName = resultsPackageName;
        this.selectorsPackageName = selectorsPackageName;
        this.outputRoot = outputRoot;
        this.schemaTypesPackagePath = schemaTypesPackagePath;
        this.operationsPackagePath = operationsPackagePath;
        this.resultsPackagePath = resultsPackagePath;
        this.selectorsPackagePath = selectorsPackagePath;
        this.parserOptions = parserOptions;
    }

    public static GqlConfigurationBuilder builder() {
        return new GqlConfigurationBuilder();
    }

    public Collection<Path> getSourceFiles() {
        return this.sourceFiles;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public Map<String, String> getScalars() {
        return this.scalars;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public boolean isGenerateDtoMethodChaining() {
        return this.generateDtoMethodChaining;
    }

    public boolean isGenerateDtoBuilder() {
        return this.generateDtoBuilder;
    }

    public boolean isGenerateDtoSetters() {
        return this.generateDtoSetters;
    }

    public boolean isGenerateDtoConstructor() {
        return this.generateDtoConstructor;
    }

    public boolean isGenerateDefinedOperations() {
        return this.generateDefinedOperations;
    }

    public boolean isGenerateDynamicOperations() {
        return this.generateDynamicOperations;
    }

    public boolean isGenerateSchemaInputTypes() {
        return this.generateSchemaInputTypes;
    }

    public boolean isGenerateSchemaOtherTypes() {
        return this.generateSchemaOtherTypes;
    }

    public String getJsonPropertyAnnotation() {
        return this.jsonPropertyAnnotation;
    }

    public String getJsonPropertyPrefix() {
        return this.jsonPropertyPrefix;
    }

    public String getJsonPropertySuffix() {
        return this.jsonPropertySuffix;
    }

    public String getGeneratedAnnotation() {
        return this.generatedAnnotation;
    }

    public String getSchemaTypesPackageName() {
        return this.schemaTypesPackageName;
    }

    public String getOperationsPackageName() {
        return this.operationsPackageName;
    }

    public String getResultsPackageName() {
        return this.resultsPackageName;
    }

    public String getSelectorsPackageName() {
        return this.selectorsPackageName;
    }

    public Path getOutputRoot() {
        return this.outputRoot;
    }

    public Path getSchemaTypesPackagePath() {
        return this.schemaTypesPackagePath;
    }

    public Path getOperationsPackagePath() {
        return this.operationsPackagePath;
    }

    public Path getResultsPackagePath() {
        return this.resultsPackagePath;
    }

    public Path getSelectorsPackagePath() {
        return this.selectorsPackagePath;
    }

    public ParserOptions getParserOptions() {
        return this.parserOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlConfiguration)) {
            return false;
        }
        GqlConfiguration other = (GqlConfiguration)o;
        if (this.isGenerateDtoMethodChaining() != other.isGenerateDtoMethodChaining()) {
            return false;
        }
        if (this.isGenerateDtoBuilder() != other.isGenerateDtoBuilder()) {
            return false;
        }
        if (this.isGenerateDtoSetters() != other.isGenerateDtoSetters()) {
            return false;
        }
        if (this.isGenerateDtoConstructor() != other.isGenerateDtoConstructor()) {
            return false;
        }
        if (this.isGenerateDefinedOperations() != other.isGenerateDefinedOperations()) {
            return false;
        }
        if (this.isGenerateDynamicOperations() != other.isGenerateDynamicOperations()) {
            return false;
        }
        if (this.isGenerateSchemaInputTypes() != other.isGenerateSchemaInputTypes()) {
            return false;
        }
        if (this.isGenerateSchemaOtherTypes() != other.isGenerateSchemaOtherTypes()) {
            return false;
        }
        Collection<Path> this$sourceFiles = this.getSourceFiles();
        Collection<Path> other$sourceFiles = other.getSourceFiles();
        if (this$sourceFiles == null ? other$sourceFiles != null : !((Object)this$sourceFiles).equals(other$sourceFiles)) {
            return false;
        }
        Set<String> this$importPackages = this.getImportPackages();
        Set<String> other$importPackages = other.getImportPackages();
        if (this$importPackages == null ? other$importPackages != null : !((Object)this$importPackages).equals(other$importPackages)) {
            return false;
        }
        Map<String, String> this$scalars = this.getScalars();
        Map<String, String> other$scalars = other.getScalars();
        if (this$scalars == null ? other$scalars != null : !((Object)this$scalars).equals(other$scalars)) {
            return false;
        }
        Map<String, String> this$aliases = this.getAliases();
        Map<String, String> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        String this$jsonPropertyAnnotation = this.getJsonPropertyAnnotation();
        String other$jsonPropertyAnnotation = other.getJsonPropertyAnnotation();
        if (this$jsonPropertyAnnotation == null ? other$jsonPropertyAnnotation != null : !this$jsonPropertyAnnotation.equals(other$jsonPropertyAnnotation)) {
            return false;
        }
        String this$jsonPropertyPrefix = this.getJsonPropertyPrefix();
        String other$jsonPropertyPrefix = other.getJsonPropertyPrefix();
        if (this$jsonPropertyPrefix == null ? other$jsonPropertyPrefix != null : !this$jsonPropertyPrefix.equals(other$jsonPropertyPrefix)) {
            return false;
        }
        String this$jsonPropertySuffix = this.getJsonPropertySuffix();
        String other$jsonPropertySuffix = other.getJsonPropertySuffix();
        if (this$jsonPropertySuffix == null ? other$jsonPropertySuffix != null : !this$jsonPropertySuffix.equals(other$jsonPropertySuffix)) {
            return false;
        }
        String this$generatedAnnotation = this.getGeneratedAnnotation();
        String other$generatedAnnotation = other.getGeneratedAnnotation();
        if (this$generatedAnnotation == null ? other$generatedAnnotation != null : !this$generatedAnnotation.equals(other$generatedAnnotation)) {
            return false;
        }
        String this$schemaTypesPackageName = this.getSchemaTypesPackageName();
        String other$schemaTypesPackageName = other.getSchemaTypesPackageName();
        if (this$schemaTypesPackageName == null ? other$schemaTypesPackageName != null : !this$schemaTypesPackageName.equals(other$schemaTypesPackageName)) {
            return false;
        }
        String this$operationsPackageName = this.getOperationsPackageName();
        String other$operationsPackageName = other.getOperationsPackageName();
        if (this$operationsPackageName == null ? other$operationsPackageName != null : !this$operationsPackageName.equals(other$operationsPackageName)) {
            return false;
        }
        String this$resultsPackageName = this.getResultsPackageName();
        String other$resultsPackageName = other.getResultsPackageName();
        if (this$resultsPackageName == null ? other$resultsPackageName != null : !this$resultsPackageName.equals(other$resultsPackageName)) {
            return false;
        }
        String this$selectorsPackageName = this.getSelectorsPackageName();
        String other$selectorsPackageName = other.getSelectorsPackageName();
        if (this$selectorsPackageName == null ? other$selectorsPackageName != null : !this$selectorsPackageName.equals(other$selectorsPackageName)) {
            return false;
        }
        Path this$outputRoot = this.getOutputRoot();
        Path other$outputRoot = other.getOutputRoot();
        if (this$outputRoot == null ? other$outputRoot != null : !((Object)this$outputRoot).equals(other$outputRoot)) {
            return false;
        }
        Path this$schemaTypesPackagePath = this.getSchemaTypesPackagePath();
        Path other$schemaTypesPackagePath = other.getSchemaTypesPackagePath();
        if (this$schemaTypesPackagePath == null ? other$schemaTypesPackagePath != null : !((Object)this$schemaTypesPackagePath).equals(other$schemaTypesPackagePath)) {
            return false;
        }
        Path this$operationsPackagePath = this.getOperationsPackagePath();
        Path other$operationsPackagePath = other.getOperationsPackagePath();
        if (this$operationsPackagePath == null ? other$operationsPackagePath != null : !((Object)this$operationsPackagePath).equals(other$operationsPackagePath)) {
            return false;
        }
        Path this$resultsPackagePath = this.getResultsPackagePath();
        Path other$resultsPackagePath = other.getResultsPackagePath();
        if (this$resultsPackagePath == null ? other$resultsPackagePath != null : !((Object)this$resultsPackagePath).equals(other$resultsPackagePath)) {
            return false;
        }
        Path this$selectorsPackagePath = this.getSelectorsPackagePath();
        Path other$selectorsPackagePath = other.getSelectorsPackagePath();
        if (this$selectorsPackagePath == null ? other$selectorsPackagePath != null : !((Object)this$selectorsPackagePath).equals(other$selectorsPackagePath)) {
            return false;
        }
        ParserOptions this$parserOptions = this.getParserOptions();
        ParserOptions other$parserOptions = other.getParserOptions();
        return !(this$parserOptions == null ? other$parserOptions != null : !this$parserOptions.equals(other$parserOptions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGenerateDtoMethodChaining() ? 79 : 97);
        result = result * 59 + (this.isGenerateDtoBuilder() ? 79 : 97);
        result = result * 59 + (this.isGenerateDtoSetters() ? 79 : 97);
        result = result * 59 + (this.isGenerateDtoConstructor() ? 79 : 97);
        result = result * 59 + (this.isGenerateDefinedOperations() ? 79 : 97);
        result = result * 59 + (this.isGenerateDynamicOperations() ? 79 : 97);
        result = result * 59 + (this.isGenerateSchemaInputTypes() ? 79 : 97);
        result = result * 59 + (this.isGenerateSchemaOtherTypes() ? 79 : 97);
        Collection<Path> $sourceFiles = this.getSourceFiles();
        result = result * 59 + ($sourceFiles == null ? 43 : ((Object)$sourceFiles).hashCode());
        Set<String> $importPackages = this.getImportPackages();
        result = result * 59 + ($importPackages == null ? 43 : ((Object)$importPackages).hashCode());
        Map<String, String> $scalars = this.getScalars();
        result = result * 59 + ($scalars == null ? 43 : ((Object)$scalars).hashCode());
        Map<String, String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        String $jsonPropertyAnnotation = this.getJsonPropertyAnnotation();
        result = result * 59 + ($jsonPropertyAnnotation == null ? 43 : $jsonPropertyAnnotation.hashCode());
        String $jsonPropertyPrefix = this.getJsonPropertyPrefix();
        result = result * 59 + ($jsonPropertyPrefix == null ? 43 : $jsonPropertyPrefix.hashCode());
        String $jsonPropertySuffix = this.getJsonPropertySuffix();
        result = result * 59 + ($jsonPropertySuffix == null ? 43 : $jsonPropertySuffix.hashCode());
        String $generatedAnnotation = this.getGeneratedAnnotation();
        result = result * 59 + ($generatedAnnotation == null ? 43 : $generatedAnnotation.hashCode());
        String $schemaTypesPackageName = this.getSchemaTypesPackageName();
        result = result * 59 + ($schemaTypesPackageName == null ? 43 : $schemaTypesPackageName.hashCode());
        String $operationsPackageName = this.getOperationsPackageName();
        result = result * 59 + ($operationsPackageName == null ? 43 : $operationsPackageName.hashCode());
        String $resultsPackageName = this.getResultsPackageName();
        result = result * 59 + ($resultsPackageName == null ? 43 : $resultsPackageName.hashCode());
        String $selectorsPackageName = this.getSelectorsPackageName();
        result = result * 59 + ($selectorsPackageName == null ? 43 : $selectorsPackageName.hashCode());
        Path $outputRoot = this.getOutputRoot();
        result = result * 59 + ($outputRoot == null ? 43 : ((Object)$outputRoot).hashCode());
        Path $schemaTypesPackagePath = this.getSchemaTypesPackagePath();
        result = result * 59 + ($schemaTypesPackagePath == null ? 43 : ((Object)$schemaTypesPackagePath).hashCode());
        Path $operationsPackagePath = this.getOperationsPackagePath();
        result = result * 59 + ($operationsPackagePath == null ? 43 : ((Object)$operationsPackagePath).hashCode());
        Path $resultsPackagePath = this.getResultsPackagePath();
        result = result * 59 + ($resultsPackagePath == null ? 43 : ((Object)$resultsPackagePath).hashCode());
        Path $selectorsPackagePath = this.getSelectorsPackagePath();
        result = result * 59 + ($selectorsPackagePath == null ? 43 : ((Object)$selectorsPackagePath).hashCode());
        ParserOptions $parserOptions = this.getParserOptions();
        result = result * 59 + ($parserOptions == null ? 43 : $parserOptions.hashCode());
        return result;
    }

    public String toString() {
        return "GqlConfiguration(sourceFiles=" + this.getSourceFiles() + ", importPackages=" + this.getImportPackages() + ", scalars=" + this.getScalars() + ", aliases=" + this.getAliases() + ", generateDtoMethodChaining=" + this.isGenerateDtoMethodChaining() + ", generateDtoBuilder=" + this.isGenerateDtoBuilder() + ", generateDtoSetters=" + this.isGenerateDtoSetters() + ", generateDtoConstructor=" + this.isGenerateDtoConstructor() + ", generateDefinedOperations=" + this.isGenerateDefinedOperations() + ", generateDynamicOperations=" + this.isGenerateDynamicOperations() + ", generateSchemaInputTypes=" + this.isGenerateSchemaInputTypes() + ", generateSchemaOtherTypes=" + this.isGenerateSchemaOtherTypes() + ", jsonPropertyAnnotation=" + this.getJsonPropertyAnnotation() + ", jsonPropertyPrefix=" + this.getJsonPropertyPrefix() + ", jsonPropertySuffix=" + this.getJsonPropertySuffix() + ", generatedAnnotation=" + this.getGeneratedAnnotation() + ", schemaTypesPackageName=" + this.getSchemaTypesPackageName() + ", operationsPackageName=" + this.getOperationsPackageName() + ", resultsPackageName=" + this.getResultsPackageName() + ", selectorsPackageName=" + this.getSelectorsPackageName() + ", outputRoot=" + this.getOutputRoot() + ", schemaTypesPackagePath=" + this.getSchemaTypesPackagePath() + ", operationsPackagePath=" + this.getOperationsPackagePath() + ", resultsPackagePath=" + this.getResultsPackagePath() + ", selectorsPackagePath=" + this.getSelectorsPackagePath() + ", parserOptions=" + this.getParserOptions() + ")";
    }

    public static class GqlConfigurationBuilder {
        private Collection<Path> sourceFiles;
        private ArrayList<String> importPackages;
        private ArrayList<String> scalars$key;
        private ArrayList<String> scalars$value;
        private ArrayList<String> aliases$key;
        private ArrayList<String> aliases$value;
        private boolean generateDtoMethodChaining;
        private boolean generateDtoBuilder;
        private boolean generateDtoSetters;
        private boolean generateDtoConstructor;
        private boolean generateDefinedOperations;
        private boolean generateDynamicOperations;
        private boolean generateSchemaInputTypes;
        private boolean generateSchemaOtherTypes;
        private String jsonPropertyAnnotation;
        private String jsonPropertyPrefix;
        private String jsonPropertySuffix;
        private String generatedAnnotation;
        private String schemaTypesPackageName;
        private String operationsPackageName;
        private String resultsPackageName;
        private String selectorsPackageName;
        private Path outputRoot;
        private Path schemaTypesPackagePath;
        private Path operationsPackagePath;
        private Path resultsPackagePath;
        private Path selectorsPackagePath;
        private ParserOptions parserOptions;

        public GqlConfigurationBuilder accept(ParameterApplier parameterApplier) throws MojoExecutionException {
            parameterApplier.apply(this);
            return this;
        }

        GqlConfigurationBuilder() {
        }

        public GqlConfigurationBuilder sourceFiles(Collection<Path> sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        public GqlConfigurationBuilder importPackage(String importPackage) {
            if (this.importPackages == null) {
                this.importPackages = new ArrayList();
            }
            this.importPackages.add(importPackage);
            return this;
        }

        public GqlConfigurationBuilder importPackages(Collection<? extends String> importPackages) {
            if (importPackages == null) {
                throw new NullPointerException("importPackages cannot be null");
            }
            if (this.importPackages == null) {
                this.importPackages = new ArrayList();
            }
            this.importPackages.addAll(importPackages);
            return this;
        }

        public GqlConfigurationBuilder clearImportPackages() {
            if (this.importPackages != null) {
                this.importPackages.clear();
            }
            return this;
        }

        public GqlConfigurationBuilder scalar(String scalarKey, String scalarValue) {
            if (this.scalars$key == null) {
                this.scalars$key = new ArrayList();
                this.scalars$value = new ArrayList();
            }
            this.scalars$key.add(scalarKey);
            this.scalars$value.add(scalarValue);
            return this;
        }

        public GqlConfigurationBuilder scalars(Map<? extends String, ? extends String> scalars) {
            if (scalars == null) {
                throw new NullPointerException("scalars cannot be null");
            }
            if (this.scalars$key == null) {
                this.scalars$key = new ArrayList();
                this.scalars$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : scalars.entrySet()) {
                this.scalars$key.add($lombokEntry.getKey());
                this.scalars$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public GqlConfigurationBuilder clearScalars() {
            if (this.scalars$key != null) {
                this.scalars$key.clear();
                this.scalars$value.clear();
            }
            return this;
        }

        public GqlConfigurationBuilder alias(String aliasKey, String aliasValue) {
            if (this.aliases$key == null) {
                this.aliases$key = new ArrayList();
                this.aliases$value = new ArrayList();
            }
            this.aliases$key.add(aliasKey);
            this.aliases$value.add(aliasValue);
            return this;
        }

        public GqlConfigurationBuilder aliases(Map<? extends String, ? extends String> aliases) {
            if (aliases == null) {
                throw new NullPointerException("aliases cannot be null");
            }
            if (this.aliases$key == null) {
                this.aliases$key = new ArrayList();
                this.aliases$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : aliases.entrySet()) {
                this.aliases$key.add($lombokEntry.getKey());
                this.aliases$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public GqlConfigurationBuilder clearAliases() {
            if (this.aliases$key != null) {
                this.aliases$key.clear();
                this.aliases$value.clear();
            }
            return this;
        }

        public GqlConfigurationBuilder generateDtoMethodChaining(boolean generateDtoMethodChaining) {
            this.generateDtoMethodChaining = generateDtoMethodChaining;
            return this;
        }

        public GqlConfigurationBuilder generateDtoBuilder(boolean generateDtoBuilder) {
            this.generateDtoBuilder = generateDtoBuilder;
            return this;
        }

        public GqlConfigurationBuilder generateDtoSetters(boolean generateDtoSetters) {
            this.generateDtoSetters = generateDtoSetters;
            return this;
        }

        public GqlConfigurationBuilder generateDtoConstructor(boolean generateDtoConstructor) {
            this.generateDtoConstructor = generateDtoConstructor;
            return this;
        }

        public GqlConfigurationBuilder generateDefinedOperations(boolean generateDefinedOperations) {
            this.generateDefinedOperations = generateDefinedOperations;
            return this;
        }

        public GqlConfigurationBuilder generateDynamicOperations(boolean generateDynamicOperations) {
            this.generateDynamicOperations = generateDynamicOperations;
            return this;
        }

        public GqlConfigurationBuilder generateSchemaInputTypes(boolean generateSchemaInputTypes) {
            this.generateSchemaInputTypes = generateSchemaInputTypes;
            return this;
        }

        public GqlConfigurationBuilder generateSchemaOtherTypes(boolean generateSchemaOtherTypes) {
            this.generateSchemaOtherTypes = generateSchemaOtherTypes;
            return this;
        }

        public GqlConfigurationBuilder jsonPropertyAnnotation(String jsonPropertyAnnotation) {
            this.jsonPropertyAnnotation = jsonPropertyAnnotation;
            return this;
        }

        public GqlConfigurationBuilder jsonPropertyPrefix(String jsonPropertyPrefix) {
            this.jsonPropertyPrefix = jsonPropertyPrefix;
            return this;
        }

        public GqlConfigurationBuilder jsonPropertySuffix(String jsonPropertySuffix) {
            this.jsonPropertySuffix = jsonPropertySuffix;
            return this;
        }

        public GqlConfigurationBuilder generatedAnnotation(String generatedAnnotation) {
            this.generatedAnnotation = generatedAnnotation;
            return this;
        }

        public GqlConfigurationBuilder schemaTypesPackageName(String schemaTypesPackageName) {
            this.schemaTypesPackageName = schemaTypesPackageName;
            return this;
        }

        public GqlConfigurationBuilder operationsPackageName(String operationsPackageName) {
            this.operationsPackageName = operationsPackageName;
            return this;
        }

        public GqlConfigurationBuilder resultsPackageName(String resultsPackageName) {
            this.resultsPackageName = resultsPackageName;
            return this;
        }

        public GqlConfigurationBuilder selectorsPackageName(String selectorsPackageName) {
            this.selectorsPackageName = selectorsPackageName;
            return this;
        }

        public GqlConfigurationBuilder outputRoot(Path outputRoot) {
            this.outputRoot = outputRoot;
            return this;
        }

        public GqlConfigurationBuilder schemaTypesPackagePath(Path schemaTypesPackagePath) {
            this.schemaTypesPackagePath = schemaTypesPackagePath;
            return this;
        }

        public GqlConfigurationBuilder operationsPackagePath(Path operationsPackagePath) {
            this.operationsPackagePath = operationsPackagePath;
            return this;
        }

        public GqlConfigurationBuilder resultsPackagePath(Path resultsPackagePath) {
            this.resultsPackagePath = resultsPackagePath;
            return this;
        }

        public GqlConfigurationBuilder selectorsPackagePath(Path selectorsPackagePath) {
            this.selectorsPackagePath = selectorsPackagePath;
            return this;
        }

        public GqlConfigurationBuilder parserOptions(ParserOptions parserOptions) {
            this.parserOptions = parserOptions;
            return this;
        }

        public GqlConfiguration build() {
            Map<Object, Object> aliases;
            Map<Object, Object> scalars;
            Set<Object> importPackages;
            switch (this.importPackages == null ? 0 : this.importPackages.size()) {
                case 0: {
                    importPackages = Collections.emptySet();
                    break;
                }
                case 1: {
                    importPackages = Collections.singleton(this.importPackages.get(0));
                    break;
                }
                default: {
                    importPackages = new LinkedHashSet(this.importPackages.size() < 0x40000000 ? 1 + this.importPackages.size() + (this.importPackages.size() - 3) / 3 : Integer.MAX_VALUE);
                    importPackages.addAll(this.importPackages);
                    importPackages = Collections.unmodifiableSet(importPackages);
                }
            }
            switch (this.scalars$key == null ? 0 : this.scalars$key.size()) {
                case 0: {
                    scalars = Collections.emptyMap();
                    break;
                }
                case 1: {
                    scalars = Collections.singletonMap(this.scalars$key.get(0), this.scalars$value.get(0));
                    break;
                }
                default: {
                    scalars = new LinkedHashMap(this.scalars$key.size() < 0x40000000 ? 1 + this.scalars$key.size() + (this.scalars$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.scalars$key.size(); ++$i) {
                        scalars.put(this.scalars$key.get($i), this.scalars$value.get($i));
                    }
                    scalars = Collections.unmodifiableMap(scalars);
                }
            }
            switch (this.aliases$key == null ? 0 : this.aliases$key.size()) {
                case 0: {
                    aliases = Collections.emptyMap();
                    break;
                }
                case 1: {
                    aliases = Collections.singletonMap(this.aliases$key.get(0), this.aliases$value.get(0));
                    break;
                }
                default: {
                    aliases = new LinkedHashMap(this.aliases$key.size() < 0x40000000 ? 1 + this.aliases$key.size() + (this.aliases$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.aliases$key.size(); ++$i) {
                        aliases.put(this.aliases$key.get($i), this.aliases$value.get($i));
                    }
                    aliases = Collections.unmodifiableMap(aliases);
                }
            }
            return new GqlConfiguration(this.sourceFiles, importPackages, scalars, aliases, this.generateDtoMethodChaining, this.generateDtoBuilder, this.generateDtoSetters, this.generateDtoConstructor, this.generateDefinedOperations, this.generateDynamicOperations, this.generateSchemaInputTypes, this.generateSchemaOtherTypes, this.jsonPropertyAnnotation, this.jsonPropertyPrefix, this.jsonPropertySuffix, this.generatedAnnotation, this.schemaTypesPackageName, this.operationsPackageName, this.resultsPackageName, this.selectorsPackageName, this.outputRoot, this.schemaTypesPackagePath, this.operationsPackagePath, this.resultsPackagePath, this.selectorsPackagePath, this.parserOptions);
        }

        public String toString() {
            return "GqlConfiguration.GqlConfigurationBuilder(sourceFiles=" + this.sourceFiles + ", importPackages=" + this.importPackages + ", scalars$key=" + this.scalars$key + ", scalars$value=" + this.scalars$value + ", aliases$key=" + this.aliases$key + ", aliases$value=" + this.aliases$value + ", generateDtoMethodChaining=" + this.generateDtoMethodChaining + ", generateDtoBuilder=" + this.generateDtoBuilder + ", generateDtoSetters=" + this.generateDtoSetters + ", generateDtoConstructor=" + this.generateDtoConstructor + ", generateDefinedOperations=" + this.generateDefinedOperations + ", generateDynamicOperations=" + this.generateDynamicOperations + ", generateSchemaInputTypes=" + this.generateSchemaInputTypes + ", generateSchemaOtherTypes=" + this.generateSchemaOtherTypes + ", jsonPropertyAnnotation=" + this.jsonPropertyAnnotation + ", jsonPropertyPrefix=" + this.jsonPropertyPrefix + ", jsonPropertySuffix=" + this.jsonPropertySuffix + ", generatedAnnotation=" + this.generatedAnnotation + ", schemaTypesPackageName=" + this.schemaTypesPackageName + ", operationsPackageName=" + this.operationsPackageName + ", resultsPackageName=" + this.resultsPackageName + ", selectorsPackageName=" + this.selectorsPackageName + ", outputRoot=" + this.outputRoot + ", schemaTypesPackagePath=" + this.schemaTypesPackagePath + ", operationsPackagePath=" + this.operationsPackagePath + ", resultsPackagePath=" + this.resultsPackagePath + ", selectorsPackagePath=" + this.selectorsPackagePath + ", parserOptions=" + this.parserOptions + ")";
        }
    }

    public static enum DataObjectEnhancementType {
        METHOD_CHAINING,
        BUILDER,
        VALUE;

    }

    public static enum GeneratedOutputType {
        SCHEMA_TYPES,
        DEFINED_OPERATIONS,
        DYNAMIC_OPERATIONS;

    }
}

