/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

import com.github.alme.graphql.generator.dto.GqlArgument;
import com.github.alme.graphql.generator.dto.GqlField;
import com.github.alme.graphql.generator.dto.GqlType;
import java.util.Collection;
import java.util.HashSet;

public final class GqlSelection {
    private final GqlField field;
    private final String alias;
    private final String fragmentTypeName;
    private final Collection<GqlSelection> selections = new HashSet<GqlSelection>();

    public GqlSelection addSelections(Collection<GqlSelection> selections) {
        if (selections != null) {
            this.selections.addAll(selections);
        }
        return this;
    }

    public String getName() {
        return this.field.getName();
    }

    public GqlType getType() {
        return this.field.getType();
    }

    public String getTitle() {
        return this.alias == null || this.alias.isEmpty() ? this.field.getName() : this.alias;
    }

    public Collection<GqlArgument> getArguments() {
        return this.field.getArguments();
    }

    public GqlSelection(GqlField field, String alias, String fragmentTypeName) {
        this.field = field;
        this.alias = alias;
        this.fragmentTypeName = fragmentTypeName;
    }

    public GqlField getField() {
        return this.field;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getFragmentTypeName() {
        return this.fragmentTypeName;
    }

    public Collection<GqlSelection> getSelections() {
        return this.selections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlSelection)) {
            return false;
        }
        GqlSelection other = (GqlSelection)o;
        GqlField this$field = this.getField();
        GqlField other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$fragmentTypeName = this.getFragmentTypeName();
        String other$fragmentTypeName = other.getFragmentTypeName();
        return !(this$fragmentTypeName == null ? other$fragmentTypeName != null : !this$fragmentTypeName.equals(other$fragmentTypeName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GqlField $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $fragmentTypeName = this.getFragmentTypeName();
        result = result * 59 + ($fragmentTypeName == null ? 43 : $fragmentTypeName.hashCode());
        return result;
    }

    public String toString() {
        return "GqlSelection(field=" + this.getField() + ", alias=" + this.getAlias() + ", fragmentTypeName=" + this.getFragmentTypeName() + ")";
    }
}

