/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

public final class GqlType {
    private final Flag flag;
    private final String name;
    private final GqlType nested;

    public static GqlType mandatory(GqlType nested) {
        return new GqlType(Flag.MANDATORY, null, nested);
    }

    public static GqlType list(GqlType nested) {
        return new GqlType(Flag.LIST, null, nested);
    }

    public static GqlType named(String name) {
        return new GqlType(Flag.NAMED, name, null);
    }

    public String getInner() {
        GqlType res = this;
        while (res.getNested() != null) {
            res = res.getNested();
        }
        return res.getName();
    }

    public String getFull() {
        switch (this.flag) {
            case MANDATORY: {
                return this.nested.getFull();
            }
            case LIST: {
                return String.format("java.util.List<%s>", this.nested.getFull());
            }
        }
        return this.name;
    }

    public String getCustom(String customType) {
        switch (this.flag) {
            case MANDATORY: {
                return this.nested.getCustom(customType);
            }
            case LIST: {
                return String.format("java.util.List<%s>", this.nested.getCustom(customType));
            }
        }
        return customType;
    }

    public String toString() {
        switch (this.flag) {
            case MANDATORY: {
                return String.format("%s!", this.nested);
            }
            case LIST: {
                return String.format("[%s]", this.nested);
            }
        }
        return this.name;
    }

    public GqlType(Flag flag, String name, GqlType nested) {
        this.flag = flag;
        this.name = name;
        this.nested = nested;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public String getName() {
        return this.name;
    }

    public GqlType getNested() {
        return this.nested;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlType)) {
            return false;
        }
        GqlType other = (GqlType)o;
        Flag this$flag = this.getFlag();
        Flag other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !((Object)((Object)this$flag)).equals((Object)other$flag)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        GqlType this$nested = this.getNested();
        GqlType other$nested = other.getNested();
        return !(this$nested == null ? other$nested != null : !((Object)this$nested).equals(other$nested));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Flag $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : ((Object)((Object)$flag)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        GqlType $nested = this.getNested();
        result = result * 59 + ($nested == null ? 43 : ((Object)$nested).hashCode());
        return result;
    }

    public static enum Flag {
        MANDATORY,
        LIST,
        NAMED;

    }
}

