/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.parameters;

import com.github.alme.graphql.generator.GeneratorMojo;
import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.parameters.ParameterApplier;
import java.time.Instant;

public class GeneratedAnnotationParameterApplier
implements ParameterApplier {
    private final String generatedAnnotationVersion;
    private static final String TEMPLATE = "@javax.annotation%s.Generated(value = \"%s\", date = \"%s\")";
    private static final String PROCESSING = ".processing";
    private static final String JAVA8 = "1.8";

    @Override
    public void apply(GqlConfiguration.GqlConfigurationBuilder builder) {
        if (this.generatedAnnotationVersion != null) {
            builder.generatedAnnotation(String.format(TEMPLATE, JAVA8.equals(this.generatedAnnotationVersion) ? "" : PROCESSING, GeneratorMojo.class.getName(), Instant.now()));
        }
    }

    public GeneratedAnnotationParameterApplier(String generatedAnnotationVersion) {
        this.generatedAnnotationVersion = generatedAnnotationVersion;
    }
}

