/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.parameters;

import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.parameters.ParameterApplier;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.project.MavenProject;

public class OutputDirectoryParameterApplier
implements ParameterApplier {
    private final MavenProject project;
    private final File outputDirectory;
    private final String packageName;
    private static final String TYPES_SUBPACKAGE = ".types";
    private static final String RESULTS_SUBPACKAGE = ".results";
    private static final String SELECTORS_SUBPACKAGE = ".selectors";
    private static final String SUBPACKAGE_SEPARATOR = ".";

    @Override
    public void apply(GqlConfiguration.GqlConfigurationBuilder builder) {
        String schemaTypesPackageName = this.packageName + TYPES_SUBPACKAGE;
        String operationsPackageName = this.packageName;
        String resultsPackageName = this.packageName + RESULTS_SUBPACKAGE;
        String selectorsPackageName = this.packageName + SELECTORS_SUBPACKAGE;
        Path outputRoot = this.getOutputDirectory(this.outputDirectory);
        Path schemaTypesPackagePath = outputRoot.resolve(schemaTypesPackageName.replace(SUBPACKAGE_SEPARATOR, File.separator));
        Path operationsPackagePath = outputRoot.resolve(operationsPackageName.replace(SUBPACKAGE_SEPARATOR, File.separator));
        Path resultsPackagePath = outputRoot.resolve(resultsPackageName.replace(SUBPACKAGE_SEPARATOR, File.separator));
        Path selectorsPackagePath = outputRoot.resolve(selectorsPackageName.replace(SUBPACKAGE_SEPARATOR, File.separator));
        builder.outputRoot(outputRoot).schemaTypesPackageName(schemaTypesPackageName).operationsPackageName(operationsPackageName).resultsPackageName(resultsPackageName).selectorsPackageName(selectorsPackageName).schemaTypesPackagePath(schemaTypesPackagePath).operationsPackagePath(operationsPackagePath).resultsPackagePath(resultsPackagePath).selectorsPackagePath(selectorsPackagePath);
    }

    private Path getOutputDirectory(File outputDirectory) {
        return outputDirectory == null ? Paths.get(this.project.getBasedir() == null ? "" : this.project.getBuild().getDirectory(), new String[0]).resolve("generated-sources").resolve("graphql-classes").resolve("java") : outputDirectory.toPath();
    }

    public OutputDirectoryParameterApplier(MavenProject project, File outputDirectory, String packageName) {
        this.project = project;
        this.outputDirectory = outputDirectory;
        this.packageName = packageName;
    }
}

