/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.parameters;

import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.parameters.ParameterApplier;
import java.util.Set;

public class OutputTypesParameterApplier
implements ParameterApplier {
    private final Set<GqlConfiguration.GeneratedOutputType> generatedOutputTypes;

    @Override
    public void apply(GqlConfiguration.GqlConfigurationBuilder builder) {
        boolean needSchemaTypes = false;
        boolean needDefinedOperations = true;
        boolean needDynamicOperations = false;
        if (this.generatedOutputTypes != null && !this.generatedOutputTypes.isEmpty()) {
            needSchemaTypes = this.generatedOutputTypes.contains((Object)GqlConfiguration.GeneratedOutputType.SCHEMA_TYPES);
            needDefinedOperations = this.generatedOutputTypes.contains((Object)GqlConfiguration.GeneratedOutputType.DEFINED_OPERATIONS);
            needDynamicOperations = this.generatedOutputTypes.contains((Object)GqlConfiguration.GeneratedOutputType.DYNAMIC_OPERATIONS);
        }
        builder.generateDefinedOperations(needDefinedOperations).generateDynamicOperations(needDynamicOperations).generateSchemaInputTypes(needSchemaTypes || needDefinedOperations || needDynamicOperations).generateSchemaOtherTypes(needSchemaTypes);
    }

    public OutputTypesParameterApplier(Set<GqlConfiguration.GeneratedOutputType> generatedOutputTypes) {
        this.generatedOutputTypes = generatedOutputTypes;
    }
}

