/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.parameters;

import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.parameters.ParameterApplier;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class ScalarMapParameterApplier
implements ParameterApplier {
    private final Map<String, String> scalarMap;
    private final Collection<String> scalarMapAlternative;
    private static final String KEY_VALUE_SEPARATOR = "=";

    @Override
    public void apply(GqlConfiguration.GqlConfigurationBuilder builder) {
        builder.scalar("Int", "Integer").scalar("Float", "Double").scalar("ID", "String");
        if (this.scalarMap != null) {
            this.scalarMap.entrySet().stream().filter(item -> item.getKey() != null && item.getValue() != null && ((String)item.getKey()).trim().length() > 0 && ((String)item.getValue()).trim().length() > 0).forEach(item -> builder.scalar(((String)item.getKey()).trim(), ((String)item.getValue()).trim()));
        } else if (this.scalarMapAlternative != null) {
            this.scalarMapAlternative.stream().filter(Objects::nonNull).map(item -> item.split(KEY_VALUE_SEPARATOR, 2)).filter(item -> ((String[])item).length == 2 && item[0].trim().length() > 0 && item[1].trim().length() > 0).forEach(item -> builder.scalar(item[0].trim(), item[1].trim()));
        }
    }

    public ScalarMapParameterApplier(Map<String, String> scalarMap, Collection<String> scalarMapAlternative) {
        this.scalarMap = scalarMap;
        this.scalarMapAlternative = scalarMapAlternative;
    }
}

