/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlField;
import com.github.alme.graphql.generator.dto.GqlOperation;
import com.github.alme.graphql.generator.dto.GqlSelection;
import com.github.alme.graphql.generator.translator.Translator;
import graphql.language.Document;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DynamicOperationTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        ctx.getDynamicSelections().putAll(DynamicOperationTranslator.createCompleteSelections(ctx));
        ctx.getSchema().forEach((operation, typeName) -> ctx.getDynamicOperations().add(new GqlOperation(null, (String)operation, (String)typeName, null)));
    }

    private static Map<String, Collection<GqlSelection>> createCompleteSelections(GqlContext ctx) {
        HashMap<String, Collection<GqlSelection>> result = new HashMap<String, Collection<GqlSelection>>();
        Map<String, String> aliasMap = ctx.getAliases();
        ctx.getObjectTypes().forEach((objectTypeName, objectType) -> result.put((String)objectTypeName, objectType.getFields().stream().map(field -> new GqlSelection((GqlField)field, aliasMap.getOrDefault(field.getName(), ""), "")).collect(Collectors.toList())));
        ctx.getInterfaceTypes().forEach((interfaceTypeName, interfaceType) -> {
            List selections = Stream.concat(interfaceType.getFields().stream().map(field -> new GqlSelection((GqlField)field, aliasMap.getOrDefault(field.getName(), ""), "")), ctx.getObjectTypes().values().stream().filter(objectType -> objectType.getMembers().contains(interfaceTypeName)).flatMap(objectType -> objectType.getFields().stream().map(field -> new GqlSelection((GqlField)field, field.getName() + '_' + objectType.getName(), objectType.getName())))).collect(Collectors.toList());
            result.put((String)interfaceTypeName, selections);
        });
        ctx.getUnionTypes().keySet().forEach(unionTypeName -> {
            List selections = ctx.getObjectTypes().values().stream().filter(objectType -> objectType.getMembers().contains(unionTypeName)).flatMap(objectType -> objectType.getFields().stream().map(field -> new GqlSelection((GqlField)field, field.getName() + '_' + objectType.getName(), objectType.getName()))).collect(Collectors.toList());
            result.put((String)unionTypeName, selections);
        });
        result.values().stream().flatMap(Collection::stream).forEach(selection -> selection.addSelections((Collection)result.get(selection.getType().getInner())));
        return result;
    }
}

