/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.translator.Translator;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValueDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class EnumTypeTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        ArrayList main = new ArrayList();
        ArrayList ext = new ArrayList();
        doc.getDefinitionsOfType(EnumTypeDefinition.class).forEach(i -> {
            if (i.getClass() == EnumTypeDefinition.class) {
                main.add(i);
            } else if (i.getClass() == EnumTypeExtensionDefinition.class) {
                ext.add((EnumTypeExtensionDefinition)i);
            }
        });
        this.populate(ctx, main);
        this.populate(ctx, ext);
    }

    private void populate(GqlContext ctx, Collection<? extends EnumTypeDefinition> definitions) {
        definitions.forEach(definition -> ctx.getEnumTypes().computeIfAbsent(definition.getName(), GqlStructure::new).addMembers(definition.getEnumValueDefinitions().stream().map(EnumValueDefinition::getName).collect(Collectors.toSet())));
    }
}

