/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.translator.Translator;
import com.github.alme.graphql.generator.translator.Util;
import graphql.language.Document;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class InputObjectTypeTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        ArrayList main = new ArrayList();
        ArrayList ext = new ArrayList();
        doc.getDefinitionsOfType(InputObjectTypeDefinition.class).forEach(i -> {
            if (i.getClass() == InputObjectTypeDefinition.class) {
                main.add(i);
            } else if (i.getClass() == InputObjectTypeExtensionDefinition.class) {
                ext.add((InputObjectTypeExtensionDefinition)i);
            }
        });
        this.populate(ctx, main);
        this.populate(ctx, ext);
    }

    private void populate(GqlContext ctx, Collection<? extends InputObjectTypeDefinition> definitions) {
        definitions.forEach(definition -> ctx.getInputObjectTypes().computeIfAbsent(definition.getName(), GqlStructure::new).addFields(definition.getInputValueDefinitions().stream().map(Util.fromInputValueDef(ctx)).collect(Collectors.toSet())));
    }
}

