/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.translator.Translator;
import com.github.alme.graphql.generator.translator.Util;
import graphql.language.Document;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class InterfaceTypeTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        ArrayList main = new ArrayList();
        ArrayList ext = new ArrayList();
        doc.getDefinitionsOfType(InterfaceTypeDefinition.class).forEach(i -> {
            if (i.getClass() == InterfaceTypeDefinition.class) {
                main.add(i);
            } else if (i.getClass() == InterfaceTypeExtensionDefinition.class) {
                ext.add((InterfaceTypeExtensionDefinition)i);
            }
        });
        this.populate(ctx, main);
        this.populate(ctx, ext);
    }

    private void populate(GqlContext ctx, Collection<? extends InterfaceTypeDefinition> definitions) {
        definitions.forEach(definition -> ctx.getInterfaceTypes().computeIfAbsent(definition.getName(), GqlStructure::new).addFields(definition.getFieldDefinitions().stream().map(Util.fromFieldDef(ctx)).collect(Collectors.toSet())).addMembers(definition.getImplements().stream().map(TypeName.class::cast).map(TypeName::getName).collect(Collectors.toSet())));
    }
}

