/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlOperation;
import com.github.alme.graphql.generator.dto.GqlSelection;
import com.github.alme.graphql.generator.translator.Translator;
import com.github.alme.graphql.generator.translator.Util;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class OperationTranslator
implements Translator {
    private static final String FRAGMENTS_KEY = "fragments";
    private static final String OPERATIONS_KEY = "operations";
    private static final String OPERATION_DOCUMENT = "OPERATION_DOCUMENT";
    private static final Configuration CFG = new Configuration(Configuration.VERSION_2_3_31);

    @Override
    public void translate(Document doc, GqlContext ctx) {
        List operations = doc.getDefinitionsOfType(OperationDefinition.class);
        List allFragments = doc.getDefinitionsOfType(FragmentDefinition.class);
        this.populate(ctx, operations, allFragments);
    }

    private void populate(GqlContext ctx, Collection<OperationDefinition> definitions, Collection<FragmentDefinition> allFragments) {
        definitions.forEach(definition -> {
            String operation = definition.getOperation().name().toLowerCase();
            String typeName = ctx.getSchema().get(operation);
            if (typeName != null) {
                HashSet<FragmentDefinition> requiredFragments = new HashSet<FragmentDefinition>();
                Collection<GqlSelection> selections = Util.translateSelection(definition.getSelectionSet(), allFragments, requiredFragments, ctx, typeName);
                String documentString = this.getDocumentString((OperationDefinition)definition, (Collection<FragmentDefinition>)requiredFragments, ctx.getLog());
                ctx.getDefinedOperations().computeIfAbsent(definition.getName(), name -> new GqlOperation((String)name, operation, typeName, documentString)).addSelections(selections).addVariables(definition.getVariableDefinitions().stream().map(Util.fromVariableDef(ctx)).collect(Collectors.toSet()));
            }
        });
    }

    private String getDocumentString(OperationDefinition operation, Collection<FragmentDefinition> fragments, Log log) {
        String string;
        HashMap<String, Collection<Object>> input = new HashMap<String, Collection<Object>>();
        input.put(OPERATIONS_KEY, Collections.singletonList(operation));
        input.put(FRAGMENTS_KEY, fragments);
        StringWriter writer = new StringWriter();
        try {
            CFG.getTemplate(OPERATION_DOCUMENT).process(input, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TemplateException | IOException e) {
                log.warn((CharSequence)String.format("Operation document [%s] is not created.", operation.getName()), e);
                return null;
            }
        }
        writer.close();
        return string;
    }

    static {
        CFG.setClassLoaderForTemplateLoading(OperationTranslator.class.getClassLoader(), "/templates/text");
        CFG.setDefaultEncoding("UTF-8");
        CFG.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        CFG.setLogTemplateExceptions(false);
        CFG.setWrapUncheckedExceptions(true);
        CFG.setFallbackOnNullLoopVariable(false);
    }
}

