/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.translator.Translator;
import com.github.alme.graphql.generator.translator.Util;
import graphql.kickstart.tools.relay.RelayConnectionFactory;
import graphql.language.Document;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeName;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class RelayConnectionTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        List definitions = doc.getDefinitions();
        List injected = new RelayConnectionFactory().create(definitions);
        this.populate(ctx, injected);
    }

    private void populate(GqlContext ctx, Collection<ObjectTypeDefinition> definitions) {
        definitions.forEach(definition -> ctx.getObjectTypes().computeIfAbsent(definition.getName(), GqlStructure::new).addMembers(definition.getImplements().stream().map(TypeName.class::cast).map(TypeName::getName).collect(Collectors.toSet())).addFields(definition.getFieldDefinitions().stream().map(Util.fromFieldDef(ctx)).collect(Collectors.toSet())));
    }
}

