/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.translator.Translator;
import graphql.language.Document;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import java.util.ArrayList;
import java.util.Collection;

public class UnionTypeTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        ArrayList main = new ArrayList();
        ArrayList ext = new ArrayList();
        doc.getDefinitionsOfType(UnionTypeDefinition.class).forEach(i -> {
            if (i.getClass() == UnionTypeDefinition.class) {
                main.add(i);
            } else if (i.getClass() == UnionTypeExtensionDefinition.class) {
                ext.add((UnionTypeExtensionDefinition)i);
            }
        });
        this.populate(ctx, main);
        this.populate(ctx, ext);
    }

    private void populate(GqlContext ctx, Collection<? extends UnionTypeDefinition> definitions) {
        definitions.forEach(definition -> {
            ctx.getUnionTypes().computeIfAbsent(definition.getName(), GqlStructure::new);
            definition.getMemberTypes().stream().map(TypeName.class::cast).map(TypeName::getName).map(name -> ctx.getObjectTypes().computeIfAbsent((String)name, GqlStructure::new)).forEach(ot -> ot.addMember(definition.getName()));
        });
    }
}

