/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.translator;

import com.github.alme.graphql.generator.dto.GqlArgument;
import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlField;
import com.github.alme.graphql.generator.dto.GqlSelection;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.dto.GqlType;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Util {
    public static GqlType translateType(Type<?> type, GqlContext ctx) {
        if (type instanceof NonNullType) {
            return GqlType.mandatory(Util.translateType(((NonNullType)type).getType(), ctx));
        }
        if (type instanceof ListType) {
            return GqlType.list(Util.translateType(((ListType)type).getType(), ctx));
        }
        if (type instanceof TypeName) {
            String name = ((TypeName)type).getName();
            return GqlType.named(ctx.getScalars().getOrDefault(name, name));
        }
        return null;
    }

    public static Collection<GqlSelection> translateSelection(SelectionSet selectionSet, Collection<FragmentDefinition> allFragments, Collection<FragmentDefinition> requiredFragments, GqlContext ctx, String typeName) {
        return Util.deepMerge(Util.streamSelection(selectionSet, allFragments, requiredFragments, ctx, typeName));
    }

    private static Stream<GqlSelection> streamSelection(SelectionSet selectionSet, Collection<FragmentDefinition> allFragments, Collection<FragmentDefinition> requiredFragments, GqlContext ctx, String typeName) {
        Stream[] streamArray = new Stream[3];
        streamArray[0] = selectionSet.getSelectionsOfType(Field.class).stream().map(field -> {
            GqlType type = Util.guessTypeOfField(field, ctx, typeName);
            String alias = field.getAlias();
            if (alias == null) {
                alias = "";
            }
            GqlSelection selection = new GqlSelection(new GqlField(field.getName(), type), alias, "");
            if (field.getSelectionSet() != null) {
                selection.addSelections(Util.translateSelection(field.getSelectionSet(), allFragments, requiredFragments, ctx, type.getInner()));
            }
            return selection;
        });
        streamArray[1] = selectionSet.getSelectionsOfType(InlineFragment.class).stream().map(fragment -> Util.translateSelection(fragment.getSelectionSet(), allFragments, requiredFragments, ctx, fragment.getTypeCondition().getName())).flatMap(Collection::stream);
        streamArray[2] = selectionSet.getSelectionsOfType(FragmentSpread.class).stream().map(FragmentSpread::getName).map(fragmentName -> allFragments.stream().filter(candidate -> Objects.equals(candidate.getName(), fragmentName)).filter(candidate -> Util.matchesByType(candidate.getTypeCondition().getName(), typeName, ctx)).findAny()).filter(Optional::isPresent).map(Optional::get).peek(requiredFragments::add).map(fragment -> Util.translateSelection(fragment.getSelectionSet(), allFragments, requiredFragments, ctx, fragment.getTypeCondition().getName())).flatMap(Collection::stream);
        return Stream.of(streamArray).flatMap(Function.identity());
    }

    private static Collection<GqlSelection> deepMerge(Stream<GqlSelection> selection) {
        return selection.reduce(new HashMap(), (result, currItem) -> {
            GqlSelection prevItem = (GqlSelection)result.remove(currItem);
            if (prevItem == null) {
                result.put(currItem, currItem);
            } else {
                GqlSelection nextItem = new GqlSelection(currItem.getField(), currItem.getAlias(), currItem.getFragmentTypeName()).addSelections(Util.deepMerge(Stream.concat(prevItem.getSelections().stream(), currItem.getSelections().stream())));
                result.put(nextItem, nextItem);
            }
            return result;
        }, (mapA, mapB) -> {
            mapA.putAll(mapB);
            return mapA;
        }).keySet();
    }

    private static GqlType guessTypeOfField(Field field, GqlContext ctx, String containerTypeName) {
        return Stream.concat(Optional.ofNullable(ctx.getObjectTypes().get(containerTypeName)).map(GqlStructure::getFields).map(Collection::stream).orElseGet(Stream::empty), Optional.ofNullable(ctx.getInterfaceTypes().get(containerTypeName)).map(GqlStructure::getFields).map(Collection::stream).orElseGet(Stream::empty)).filter(candidate -> Objects.equals(field.getName(), candidate.getName())).map(GqlField::getType).findAny().orElse(GqlType.named("String"));
    }

    private static boolean matchesByType(String candidateType, String selectionType, GqlContext ctx) {
        if (Objects.equals(selectionType, candidateType)) {
            return true;
        }
        HashSet<String> candidateTypes = new HashSet<String>();
        candidateTypes.add(candidateType);
        HashSet<String> selectionTypes = new HashSet<String>();
        selectionTypes.add(selectionType);
        ctx.getObjectTypes().values().forEach(typeStructure -> {
            if (typeStructure.getMembers().contains(candidateType)) {
                candidateTypes.add(typeStructure.getName());
            }
            if (typeStructure.getMembers().contains(selectionType)) {
                selectionTypes.add(typeStructure.getName());
            }
        });
        return !Collections.disjoint(selectionTypes, candidateTypes);
    }

    public static Function<FieldDefinition, GqlField> fromFieldDef(GqlContext ctx) {
        return v -> new GqlField(v.getName(), Util.translateType(v.getType(), ctx)).addArguments(v.getInputValueDefinitions().stream().map(definition -> new GqlArgument(definition.getName(), Util.translateType(definition.getType(), ctx))).collect(Collectors.toList()));
    }

    public static Function<InputValueDefinition, GqlField> fromInputValueDef(GqlContext ctx) {
        return v -> new GqlField(v.getName(), Util.translateType(v.getType(), ctx));
    }

    public static Function<VariableDefinition, GqlField> fromVariableDef(GqlContext ctx) {
        return v -> new GqlField(v.getName(), Util.translateType(v.getType(), ctx));
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

