/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

import com.github.alme.graphql.generator.dto.GqlType;
import com.github.alme.graphql.generator.io.Util;
import graphql.language.InputValueDefinition;
import java.util.List;
import java.util.function.UnaryOperator;

public final class GqlArgument {
    private final String name;
    private final GqlType type;
    private final List<String> javadoc;

    public static GqlArgument of(InputValueDefinition definition, UnaryOperator<String> naming) {
        return new GqlArgument(definition.getName(), GqlType.of(definition.getType(), naming), Util.extractJavadoc(definition));
    }

    public GqlArgument(String name, GqlType type, List<String> javadoc) {
        this.name = name;
        this.type = type;
        this.javadoc = javadoc;
    }

    public String getName() {
        return this.name;
    }

    public GqlType getType() {
        return this.type;
    }

    public List<String> getJavadoc() {
        return this.javadoc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlArgument)) {
            return false;
        }
        GqlArgument other = (GqlArgument)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        GqlType this$type = this.getType();
        GqlType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        GqlType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public String toString() {
        return "GqlArgument(name=" + this.getName() + ", type=" + this.getType() + ")";
    }
}

