/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

import com.github.alme.graphql.generator.dto.GqlOperation;
import com.github.alme.graphql.generator.dto.GqlSelection;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.dto.Structure;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public final class GqlContext {
    private final Log log;
    private final Map<String, String> scalars;
    private final Map<String, String> aliases;
    private final Map<String, String> operations = new HashMap<String, String>();
    private final List<String> schemaJavadoc = new LinkedList<String>();
    private final Map<Structure, Map<String, GqlStructure>> structures = new EnumMap<Structure, Map<String, GqlStructure>>(Structure.class);
    private final Map<String, GqlOperation> definedOperations = new HashMap<String, GqlOperation>();
    private final Map<String, Map<String, Collection<GqlSelection>>> definedSelections = new HashMap<String, Map<String, Collection<GqlSelection>>>();
    private final Map<String, GqlOperation> dynamicOperations = new HashMap<String, GqlOperation>();
    private final Map<String, Collection<GqlSelection>> dynamicSelections = new HashMap<String, Collection<GqlSelection>>();

    private Map<String, GqlStructure> getStructures(Structure category) {
        return this.structures.computeIfAbsent(category, s -> new HashMap());
    }

    public Map<String, GqlStructure> getInterfaceTypes() {
        return this.getStructures(Structure.INTERFACE);
    }

    public Map<String, GqlStructure> getEnumTypes() {
        return this.getStructures(Structure.ENUM);
    }

    public Map<String, GqlStructure> getObjectTypes() {
        return this.getStructures(Structure.OBJECT);
    }

    public Map<String, GqlStructure> getInputObjectTypes() {
        return this.getStructures(Structure.INPUT_OBJECT);
    }

    public String applyNaming(String name) {
        return this.scalars.getOrDefault(name, name);
    }

    public String getAlias(String name) {
        return this.aliases.get(name);
    }

    public GqlContext(Log log, Map<String, String> scalars, Map<String, String> aliases) {
        this.log = log;
        this.scalars = scalars;
        this.aliases = aliases;
    }

    public Log getLog() {
        return this.log;
    }

    public Map<String, String> getScalars() {
        return this.scalars;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public Map<String, String> getOperations() {
        return this.operations;
    }

    public List<String> getSchemaJavadoc() {
        return this.schemaJavadoc;
    }

    public Map<Structure, Map<String, GqlStructure>> getStructures() {
        return this.structures;
    }

    public Map<String, GqlOperation> getDefinedOperations() {
        return this.definedOperations;
    }

    public Map<String, Map<String, Collection<GqlSelection>>> getDefinedSelections() {
        return this.definedSelections;
    }

    public Map<String, GqlOperation> getDynamicOperations() {
        return this.dynamicOperations;
    }

    public Map<String, Collection<GqlSelection>> getDynamicSelections() {
        return this.dynamicSelections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlContext)) {
            return false;
        }
        GqlContext other = (GqlContext)o;
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        Map<String, String> this$scalars = this.getScalars();
        Map<String, String> other$scalars = other.getScalars();
        if (this$scalars == null ? other$scalars != null : !((Object)this$scalars).equals(other$scalars)) {
            return false;
        }
        Map<String, String> this$aliases = this.getAliases();
        Map<String, String> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        Map<String, String> this$operations = this.getOperations();
        Map<String, String> other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
            return false;
        }
        List<String> this$schemaJavadoc = this.getSchemaJavadoc();
        List<String> other$schemaJavadoc = other.getSchemaJavadoc();
        if (this$schemaJavadoc == null ? other$schemaJavadoc != null : !((Object)this$schemaJavadoc).equals(other$schemaJavadoc)) {
            return false;
        }
        Map<Structure, Map<String, GqlStructure>> this$structures = this.getStructures();
        Map<Structure, Map<String, GqlStructure>> other$structures = other.getStructures();
        if (this$structures == null ? other$structures != null : !((Object)this$structures).equals(other$structures)) {
            return false;
        }
        Map<String, GqlOperation> this$definedOperations = this.getDefinedOperations();
        Map<String, GqlOperation> other$definedOperations = other.getDefinedOperations();
        if (this$definedOperations == null ? other$definedOperations != null : !((Object)this$definedOperations).equals(other$definedOperations)) {
            return false;
        }
        Map<String, Map<String, Collection<GqlSelection>>> this$definedSelections = this.getDefinedSelections();
        Map<String, Map<String, Collection<GqlSelection>>> other$definedSelections = other.getDefinedSelections();
        if (this$definedSelections == null ? other$definedSelections != null : !((Object)this$definedSelections).equals(other$definedSelections)) {
            return false;
        }
        Map<String, GqlOperation> this$dynamicOperations = this.getDynamicOperations();
        Map<String, GqlOperation> other$dynamicOperations = other.getDynamicOperations();
        if (this$dynamicOperations == null ? other$dynamicOperations != null : !((Object)this$dynamicOperations).equals(other$dynamicOperations)) {
            return false;
        }
        Map<String, Collection<GqlSelection>> this$dynamicSelections = this.getDynamicSelections();
        Map<String, Collection<GqlSelection>> other$dynamicSelections = other.getDynamicSelections();
        return !(this$dynamicSelections == null ? other$dynamicSelections != null : !((Object)this$dynamicSelections).equals(other$dynamicSelections));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        Map<String, String> $scalars = this.getScalars();
        result = result * 59 + ($scalars == null ? 43 : ((Object)$scalars).hashCode());
        Map<String, String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        Map<String, String> $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        List<String> $schemaJavadoc = this.getSchemaJavadoc();
        result = result * 59 + ($schemaJavadoc == null ? 43 : ((Object)$schemaJavadoc).hashCode());
        Map<Structure, Map<String, GqlStructure>> $structures = this.getStructures();
        result = result * 59 + ($structures == null ? 43 : ((Object)$structures).hashCode());
        Map<String, GqlOperation> $definedOperations = this.getDefinedOperations();
        result = result * 59 + ($definedOperations == null ? 43 : ((Object)$definedOperations).hashCode());
        Map<String, Map<String, Collection<GqlSelection>>> $definedSelections = this.getDefinedSelections();
        result = result * 59 + ($definedSelections == null ? 43 : ((Object)$definedSelections).hashCode());
        Map<String, GqlOperation> $dynamicOperations = this.getDynamicOperations();
        result = result * 59 + ($dynamicOperations == null ? 43 : ((Object)$dynamicOperations).hashCode());
        Map<String, Collection<GqlSelection>> $dynamicSelections = this.getDynamicSelections();
        result = result * 59 + ($dynamicSelections == null ? 43 : ((Object)$dynamicSelections).hashCode());
        return result;
    }

    public String toString() {
        return "GqlContext(log=" + this.getLog() + ", scalars=" + this.getScalars() + ", aliases=" + this.getAliases() + ", operations=" + this.getOperations() + ", schemaJavadoc=" + this.getSchemaJavadoc() + ", structures=" + this.getStructures() + ", definedOperations=" + this.getDefinedOperations() + ", definedSelections=" + this.getDefinedSelections() + ", dynamicOperations=" + this.getDynamicOperations() + ", dynamicSelections=" + this.getDynamicSelections() + ")";
    }
}

