/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

import com.github.alme.graphql.generator.dto.GqlArgument;
import com.github.alme.graphql.generator.dto.GqlType;
import com.github.alme.graphql.generator.io.Util;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.VariableDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class GqlField {
    private final String name;
    private final GqlType type;
    private final Set<GqlArgument> arguments;
    private final List<String> javadoc;

    public static GqlField of(FieldDefinition definition, UnaryOperator<String> naming) {
        return new GqlField(definition.getName(), GqlType.of(definition.getType(), naming), definition.getInputValueDefinitions().stream().map(d -> GqlArgument.of(d, naming)).collect(Collectors.toSet()), Util.extractJavadoc(definition));
    }

    public static GqlField of(InputValueDefinition definition, UnaryOperator<String> naming) {
        return new GqlField(definition.getName(), GqlType.of(definition.getType(), naming), Collections.emptySet(), Util.extractJavadoc(definition));
    }

    public static GqlField of(VariableDefinition definition, UnaryOperator<String> naming) {
        return new GqlField(definition.getName(), GqlType.of(definition.getType(), naming), Collections.emptySet(), Collections.emptyList());
    }

    public static GqlField of(String name, GqlType type) {
        return new GqlField(name, type, Collections.emptySet(), Collections.emptyList());
    }

    public GqlField(String name, GqlType type, Set<GqlArgument> arguments, List<String> javadoc) {
        this.name = name;
        this.type = type;
        this.arguments = arguments;
        this.javadoc = javadoc;
    }

    public String getName() {
        return this.name;
    }

    public GqlType getType() {
        return this.type;
    }

    public Set<GqlArgument> getArguments() {
        return this.arguments;
    }

    public List<String> getJavadoc() {
        return this.javadoc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlField)) {
            return false;
        }
        GqlField other = (GqlField)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        GqlType this$type = this.getType();
        GqlType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        GqlType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public String toString() {
        return "GqlField(name=" + this.getName() + ", type=" + this.getType() + ", arguments=" + this.getArguments() + ")";
    }
}

