/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

import com.github.alme.graphql.generator.dto.GqlArgument;
import com.github.alme.graphql.generator.dto.GqlField;
import com.github.alme.graphql.generator.dto.GqlType;
import graphql.language.SelectionSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GqlSelection {
    private final GqlField field;
    private final String alias;
    private final String fragmentTypeName;
    private final Set<SelectionSet> subsets;
    private String targetTypeName;

    public String getKey() {
        return String.format("%s:%s:%s:%s", this.alias, this.field.getName(), this.field.getType(), this.fragmentTypeName);
    }

    public static GqlSelection of(GqlField field, String alias, String fragmentTypeName) {
        return new GqlSelection(field, alias, fragmentTypeName, Collections.emptySet());
    }

    public static GqlSelection of(GqlField field, String alias, SelectionSet subset) {
        return new GqlSelection(field, alias, "", GqlSelection.getSubsets(subset));
    }

    public static GqlSelection of(GqlField field, String alias) {
        return new GqlSelection(field, alias, "", Collections.emptySet());
    }

    public static GqlSelection of(String typeName, SelectionSet subset) {
        return new GqlSelection(GqlField.of(null, GqlType.named(typeName)), null, "", GqlSelection.getSubsets(subset));
    }

    private static Set<SelectionSet> getSubsets(SelectionSet subset) {
        return Optional.ofNullable(subset).map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    public GqlSelection merge(GqlSelection that) {
        return new GqlSelection(this.field, this.alias, this.fragmentTypeName, Stream.concat(this.subsets.stream(), that.subsets.stream()).collect(Collectors.toSet()));
    }

    public String getTitle() {
        return this.alias == null || this.alias.isEmpty() ? this.field.getName() : this.alias;
    }

    public GqlField getField() {
        return this.field;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getFragmentTypeName() {
        return this.fragmentTypeName;
    }

    public Set<SelectionSet> getSubsets() {
        return this.subsets;
    }

    public String getTargetTypeName() {
        return this.targetTypeName;
    }

    public GqlSelection(GqlField field, String alias, String fragmentTypeName, Set<SelectionSet> subsets) {
        this.field = field;
        this.alias = alias;
        this.fragmentTypeName = fragmentTypeName;
        this.subsets = subsets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlSelection)) {
            return false;
        }
        GqlSelection other = (GqlSelection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GqlField this$field = this.getField();
        GqlField other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$fragmentTypeName = this.getFragmentTypeName();
        String other$fragmentTypeName = other.getFragmentTypeName();
        return !(this$fragmentTypeName == null ? other$fragmentTypeName != null : !this$fragmentTypeName.equals(other$fragmentTypeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GqlSelection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GqlField $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $fragmentTypeName = this.getFragmentTypeName();
        result = result * 59 + ($fragmentTypeName == null ? 43 : $fragmentTypeName.hashCode());
        return result;
    }

    public String toString() {
        return "GqlSelection(field=" + this.getField() + ", alias=" + this.getAlias() + ", fragmentTypeName=" + this.getFragmentTypeName() + ", targetTypeName=" + this.getTargetTypeName() + ")";
    }

    public void setTargetTypeName(String targetTypeName) {
        this.targetTypeName = targetTypeName;
    }

    public String getName() {
        return this.getField().getName();
    }

    public GqlType getType() {
        return this.getField().getType();
    }

    public Set<GqlArgument> getArguments() {
        return this.getField().getArguments();
    }

    public List<String> getJavadoc() {
        return this.getField().getJavadoc();
    }
}

