/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.dto;

import com.github.alme.graphql.generator.dto.GqlField;
import com.github.alme.graphql.generator.dto.GqlValue;
import com.github.alme.graphql.generator.io.Util;
import graphql.language.EnumTypeDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GqlStructure {
    private final String name;
    private final Set<String> parents;
    private final Set<GqlField> fields;
    private final Set<GqlValue> values;
    private final List<String> javadoc;

    public static GqlStructure of(InterfaceTypeDefinition definition, UnaryOperator<String> naming) {
        return new GqlStructure(definition.getName(), definition.getImplements().stream().map(TypeName.class::cast).map(TypeName::getName).collect(Collectors.toSet()), definition.getFieldDefinitions().stream().map(v -> GqlField.of(v, naming)).collect(Collectors.toSet()), Collections.emptySet(), Util.extractJavadoc(definition));
    }

    public static GqlStructure of(ObjectTypeDefinition definition, UnaryOperator<String> naming) {
        return new GqlStructure(definition.getName(), definition.getImplements().stream().map(TypeName.class::cast).map(TypeName::getName).collect(Collectors.toSet()), definition.getFieldDefinitions().stream().map(v -> GqlField.of(v, naming)).collect(Collectors.toSet()), Collections.emptySet(), Util.extractJavadoc(definition));
    }

    public static GqlStructure of(InputObjectTypeDefinition definition, UnaryOperator<String> naming) {
        return new GqlStructure(definition.getName(), Collections.emptySet(), definition.getInputValueDefinitions().stream().map(v -> GqlField.of(v, naming)).collect(Collectors.toSet()), Collections.emptySet(), Util.extractJavadoc(definition));
    }

    public static GqlStructure of(EnumTypeDefinition definition) {
        return new GqlStructure(definition.getName(), Collections.emptySet(), Collections.emptySet(), definition.getEnumValueDefinitions().stream().map(GqlValue::of).collect(Collectors.toSet()), Util.extractJavadoc(definition));
    }

    public static GqlStructure of(UnionTypeDefinition definition) {
        return new GqlStructure(definition.getName(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Util.extractJavadoc(definition));
    }

    public static GqlStructure of(String name, String parentName) {
        return new GqlStructure(name, Optional.ofNullable(parentName).map(Collections::singleton).orElseGet(Collections::emptySet), Collections.emptySet(), Collections.emptySet(), Collections.emptyList());
    }

    public GqlStructure merge(GqlStructure that) {
        return new GqlStructure(this.name, Stream.concat(this.parents.stream(), that.parents.stream()).collect(Collectors.toSet()), Stream.concat(this.fields.stream(), that.fields.stream()).collect(Collectors.toSet()), Stream.concat(this.values.stream(), that.values.stream()).collect(Collectors.toSet()), Stream.concat(this.javadoc.stream(), that.javadoc.stream()).collect(Collectors.toList()));
    }

    public GqlStructure(String name, Set<String> parents, Set<GqlField> fields, Set<GqlValue> values, List<String> javadoc) {
        this.name = name;
        this.parents = parents;
        this.fields = fields;
        this.values = values;
        this.javadoc = javadoc;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getParents() {
        return this.parents;
    }

    public Set<GqlField> getFields() {
        return this.fields;
    }

    public Set<GqlValue> getValues() {
        return this.values;
    }

    public List<String> getJavadoc() {
        return this.javadoc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GqlStructure)) {
            return false;
        }
        GqlStructure other = (GqlStructure)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<String> this$parents = this.getParents();
        Set<String> other$parents = other.getParents();
        if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
            return false;
        }
        Set<GqlField> this$fields = this.getFields();
        Set<GqlField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Set<GqlValue> this$values = this.getValues();
        Set<GqlValue> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<String> $parents = this.getParents();
        result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
        Set<GqlField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Set<GqlValue> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "GqlStructure(name=" + this.getName() + ", parents=" + this.getParents() + ", fields=" + this.getFields() + ", values=" + this.getValues() + ")";
    }
}

