/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.io;

import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlSelection;
import com.github.alme.graphql.generator.dto.Structure;
import com.github.alme.graphql.generator.io.Util;
import com.github.alme.graphql.generator.io.WriterFactory;
import com.github.alme.graphql.generator.io.creator.AppenderFileCreator;
import com.github.alme.graphql.generator.io.creator.DefinedOperationFileCreator;
import com.github.alme.graphql.generator.io.creator.DefinedOperationResultFileCreator;
import com.github.alme.graphql.generator.io.creator.DefinedOperationVariablesFileCreator;
import com.github.alme.graphql.generator.io.creator.DynamicOperationFileCreator;
import com.github.alme.graphql.generator.io.creator.DynamicOperationResultFileCreator;
import com.github.alme.graphql.generator.io.creator.DynamicOperationSelectorFileCreator;
import com.github.alme.graphql.generator.io.creator.OperationInterfaceFileCreator;
import com.github.alme.graphql.generator.io.creator.StructureFileCreator;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModelException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;

public class GqlWriter {
    private static final String APPENDER_CLASS_NAME = "GraphQlAppender";
    private static final String JSON_PROPERTY_KEY = "jsonProperty";
    private static final String PROPERTY_PREFIX_KEY = "propertyPrefix";
    private static final String PROPERTY_SUFFIX_KEY = "propertySuffix";
    private static final String DTO_METHOD_CHAINING_KEY = "dtoMethodChaining";
    private static final String DTO_BUILDER_KEY = "dtoBuilder";
    private static final String DTO_SETTERS_KEY = "dtoSetters";
    private static final String DTO_CONSTRUCTOR_KEY = "dtoConstructor";
    private static final String IMPORT_PACKAGES_KEY = "importPackages";
    private static final String GENERATED_ANNOTATION_KEY = "generatedAnnotation";
    private static final String SCHEMA_TYPES_PACKAGE_KEY = "schemaTypesPackage";
    private static final String OPERATIONS_PACKAGE_KEY = "operationsPackage";
    private static final String DEFINED_OPERATIONS_PACKAGE_KEY = "definedOperationsPackage";
    private static final String DYNAMIC_OPERATIONS_PACKAGE_KEY = "dynamicOperationsPackage";
    private final WriterFactory writerFactory;
    private final Configuration freemarker;

    public GqlWriter(WriterFactory writerFactory) {
        this.writerFactory = writerFactory;
        this.freemarker = new Configuration(Configuration.VERSION_2_3_32);
        this.freemarker.setClassLoaderForTemplateLoading(GqlWriter.class.getClassLoader(), "/templates/java");
        this.freemarker.setDefaultEncoding(StandardCharsets.UTF_8.displayName());
        this.freemarker.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarker.setLogTemplateExceptions(false);
        this.freemarker.setWrapUncheckedExceptions(true);
        this.freemarker.setFallbackOnNullLoopVariable(false);
        this.freemarker.setTabSize(4);
    }

    public void write(GqlContext context, GqlConfiguration configuration) throws MojoExecutionException {
        this.setTemplateVariables(configuration);
        this.createSharedClasses(context, configuration);
        this.createSchemaTypes(context, configuration);
        this.createOperationInterfaces(context, configuration);
        this.createDefinedOperations(context, configuration);
        this.createDynamicOperations(context, configuration);
        this.clearTemplateVariables();
    }

    private void setTemplateVariables(GqlConfiguration configuration) throws MojoExecutionException {
        try {
            this.freemarker.setSharedVariable(SCHEMA_TYPES_PACKAGE_KEY, (Object)configuration.getSchemaTypesPackageName());
            this.freemarker.setSharedVariable(OPERATIONS_PACKAGE_KEY, (Object)configuration.getOperationsPackageName());
            this.freemarker.setSharedVariable(DEFINED_OPERATIONS_PACKAGE_KEY, (Object)configuration.getDefinedOperationsPackageName());
            this.freemarker.setSharedVariable(DYNAMIC_OPERATIONS_PACKAGE_KEY, (Object)configuration.getDynamicOperationsPackageName());
            this.freemarker.setSharedVariable(JSON_PROPERTY_KEY, (Object)configuration.getJsonPropertyAnnotation());
            this.freemarker.setSharedVariable(PROPERTY_PREFIX_KEY, (Object)configuration.getJsonPropertyPrefix());
            this.freemarker.setSharedVariable(PROPERTY_SUFFIX_KEY, (Object)configuration.getJsonPropertySuffix());
            this.freemarker.setSharedVariable(DTO_METHOD_CHAINING_KEY, (Object)configuration.isGenerateDtoMethodChaining());
            this.freemarker.setSharedVariable(DTO_BUILDER_KEY, (Object)configuration.isGenerateDtoBuilder());
            this.freemarker.setSharedVariable(DTO_SETTERS_KEY, (Object)configuration.isGenerateDtoSetters());
            this.freemarker.setSharedVariable(DTO_CONSTRUCTOR_KEY, (Object)configuration.isGenerateDtoConstructor());
            this.freemarker.setSharedVariable(IMPORT_PACKAGES_KEY, configuration.getImportPackages());
            this.freemarker.setSharedVariable(GENERATED_ANNOTATION_KEY, (Object)configuration.getGeneratedAnnotation());
        }
        catch (TemplateModelException e) {
            throw new MojoExecutionException("Cannot set shared variables.", (Exception)((Object)e));
        }
    }

    private void clearTemplateVariables() {
        this.freemarker.clearSharedVariables();
    }

    private void createSharedClasses(GqlContext context, GqlConfiguration configuration) {
        if (configuration.isGenerateSchemaInputTypes() && !context.getInputObjectTypes().isEmpty() || configuration.isGenerateDynamicOperations() && !context.getDynamicOperations().isEmpty()) {
            new AppenderFileCreator(this.writerFactory, this.freemarker).createFile(configuration.getOperationsPackageName(), APPENDER_CLASS_NAME, null);
        }
    }

    private void createSchemaTypes(GqlContext context, GqlConfiguration configuration) {
        String packageName = configuration.getSchemaTypesPackageName();
        int count = 0;
        if (configuration.isGenerateSchemaInputTypes()) {
            StructureFileCreator inputObjectFileCreator = new StructureFileCreator(this.writerFactory, this.freemarker, Structure.INPUT_OBJECT);
            context.getInputObjectTypes().forEach((className, gqlStructure) -> inputObjectFileCreator.createFile(packageName, (String)className, gqlStructure));
            count += context.getInputObjectTypes().size();
        }
        if (configuration.isGenerateSchemaInputTypes() || configuration.isGenerateSchemaOtherTypes()) {
            StructureFileCreator enumFileCreator = new StructureFileCreator(this.writerFactory, this.freemarker, Structure.ENUM);
            context.getEnumTypes().forEach((className, gqlStructure) -> enumFileCreator.createFile(packageName, (String)className, gqlStructure));
            count += context.getEnumTypes().size();
        }
        if (configuration.isGenerateSchemaOtherTypes()) {
            StructureFileCreator interfaceFileCreator = new StructureFileCreator(this.writerFactory, this.freemarker, Structure.INTERFACE);
            context.getInterfaceTypes().forEach((className, gqlStructure) -> interfaceFileCreator.createFile(packageName, (String)className, gqlStructure));
            count += context.getInterfaceTypes().size();
            StructureFileCreator objectFileCreator = new StructureFileCreator(this.writerFactory, this.freemarker, Structure.OBJECT);
            context.getObjectTypes().forEach((className, gqlStructure) -> objectFileCreator.createFile(packageName, (String)className, gqlStructure));
            count += context.getObjectTypes().size();
        }
        if (count > 0) {
            context.getLog().info((CharSequence)String.format("Finished creating %d schema type class(es).", count));
        }
    }

    private void createOperationInterfaces(GqlContext context, GqlConfiguration configuration) {
        if (configuration.isGenerateDefinedOperations() && !context.getDefinedOperations().isEmpty() || configuration.isGenerateDynamicOperations() && !context.getDynamicOperations().isEmpty()) {
            OperationInterfaceFileCreator operationInterfaceFileCreator = new OperationInterfaceFileCreator(this.writerFactory, this.freemarker);
            context.getOperations().keySet().stream().map(Util::firstUpper).forEach(interfaceName -> operationInterfaceFileCreator.createFile(configuration.getOperationsPackageName(), (String)interfaceName, Collections.singletonMap("javadoc", context.getSchemaJavadoc())));
        }
    }

    private void createDefinedOperations(GqlContext context, GqlConfiguration configuration) {
        if (configuration.isGenerateDefinedOperations() && !context.getDefinedOperations().isEmpty()) {
            DefinedOperationFileCreator definedOperationFileCreator = new DefinedOperationFileCreator(this.writerFactory, this.freemarker);
            DefinedOperationVariablesFileCreator definedOperationVariablesFileCreator = new DefinedOperationVariablesFileCreator(this.writerFactory, this.freemarker);
            context.getDefinedOperations().forEach((operationName, operation) -> {
                String packageName = configuration.getDefinedOperationsPackageName() + "." + Util.firstLower(operationName);
                definedOperationFileCreator.createFile(packageName, (String)operationName, operation);
                if (!operation.getVariables().isEmpty()) {
                    definedOperationVariablesFileCreator.createFile(packageName, operationName + "Variables", operation);
                }
            });
            DefinedOperationResultFileCreator definedOperationResultFileCreator = new DefinedOperationResultFileCreator(this.writerFactory, this.freemarker);
            context.getDefinedSelections().forEach((operationName, typeMap) -> {
                String packageName = configuration.getDefinedOperationsPackageName() + "." + Util.firstLower(operationName) + ".results";
                typeMap.forEach((typeName, selections) -> definedOperationResultFileCreator.createFile(packageName, (String)typeName, Collections.singletonMap("selections", selections)));
            });
            context.getDefinedOperations().forEach((operationName, operation) -> context.getLog().info((CharSequence)String.format("Finished creating %d class(es) for %s operation.", (operation.getVariables().isEmpty() ? 1 : 2) + context.getDefinedSelections().get(operationName).size(), operationName)));
        }
    }

    private void createDynamicOperations(GqlContext context, GqlConfiguration configuration) {
        if (configuration.isGenerateDynamicOperations() && !context.getDynamicOperations().isEmpty()) {
            String packageName = configuration.getDynamicOperationsPackageName();
            DynamicOperationFileCreator dynamicOperationFileCreator = new DynamicOperationFileCreator(this.writerFactory, this.freemarker);
            context.getDynamicOperations().forEach((className, operation) -> dynamicOperationFileCreator.createFile(packageName, (String)className, operation));
            DynamicOperationResultFileCreator dynamicOperationResultFileCreator = new DynamicOperationResultFileCreator(this.writerFactory, this.freemarker);
            DynamicOperationSelectorFileCreator dynamicOperationSelectorFileCreator = new DynamicOperationSelectorFileCreator(this.writerFactory, this.freemarker);
            context.getDynamicSelections().forEach((className, selections) -> {
                dynamicOperationResultFileCreator.createFile(packageName + ".results", (String)className, Collections.singletonMap("selections", selections));
                dynamicOperationSelectorFileCreator.createFile(packageName + ".selectors", className + "Selector", Collections.singletonMap("selections", selections.stream().collect(Collectors.groupingBy(GqlSelection::getFragmentTypeName))));
            });
            context.getLog().info((CharSequence)String.format("Finished creating %d dynamic operation(s) with %d common class(es).", context.getDynamicOperations().size(), context.getDynamicSelections().size() * 2));
        }
    }
}

