/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.io;

import graphql.parser.MultiSourceReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;

public class ReaderFactory {
    private final Collection<Path> sources;
    private final Log log;

    public Reader getReader() {
        return this.sources.stream().map(path -> {
            try {
                return new FileInfo(Files.newBufferedReader(path), path.toString());
            }
            catch (IOException e) {
                this.log.error((CharSequence)String.format("Skipping [%s].", path), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).reduce(MultiSourceReader.newMultiSourceReader(), (multiReader, fileInfo) -> multiReader.reader(((FileInfo)fileInfo).reader, ((FileInfo)fileInfo).path), (r1, r2) -> null).build();
    }

    public ReaderFactory(Collection<Path> sources, Log log) {
        this.sources = sources;
        this.log = log;
    }

    private static final class FileInfo {
        private final Reader reader;
        private final String path;

        public FileInfo(Reader reader, String path) {
            this.reader = reader;
            this.path = path;
        }

        public Reader getReader() {
            return this.reader;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo other = (FileInfo)o;
            Reader this$reader = this.getReader();
            Reader other$reader = other.getReader();
            if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Reader $reader = this.getReader();
            result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "ReaderFactory.FileInfo(reader=" + this.getReader() + ", path=" + this.getPath() + ")";
        }
    }
}

