/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.io;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class WriterFactory {
    private static final String FILE_EXTENSION = ".java";
    private static final char SUBPACKAGE_SEPARATOR = '.';
    private static final char FS_SEPARATOR = File.separatorChar;
    private final Path outputRoot;

    public Writer getWriter(String packageName, String className) throws IOException {
        Path filePath = this.outputRoot.resolve(packageName.replace('.', FS_SEPARATOR)).resolve(className + FILE_EXTENSION);
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        return Files.newBufferedWriter(filePath, new OpenOption[0]);
    }

    public WriterFactory(Path outputRoot) {
        this.outputRoot = outputRoot;
    }
}

