/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.io.creator;

import com.github.alme.graphql.generator.io.WriterFactory;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;

abstract class FileCreator {
    private static final String LOG_CANNOT_CREATE = "Cannot create %s.%s";
    private static final String CLASS_NAME_KEY = "className";
    private static final String CURRENT_PACKAGE_KEY = "currentPackage";
    private final WriterFactory writerFactory;
    private final Configuration freemarker;

    public void createFile(String packageName, String className, Object baseObject) {
        try (Writer writer = this.writerFactory.getWriter(packageName, className);){
            this.freemarker.setSharedVariable(CLASS_NAME_KEY, (Object)className);
            this.freemarker.setSharedVariable(CURRENT_PACKAGE_KEY, (Object)packageName);
            this.freemarker.getTemplate(this.getTemplate()).process(baseObject, writer);
        }
        catch (TemplateException | IOException e) {
            throw new MojoExecutionException(String.format(LOG_CANNOT_CREATE, packageName, className), (Exception)e);
        }
    }

    protected abstract String getTemplate();

    public FileCreator(WriterFactory writerFactory, Configuration freemarker) {
        this.writerFactory = writerFactory;
        this.freemarker = freemarker;
    }
}

