/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.io.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.io.translator.Translator;
import graphql.language.Document;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import java.util.ArrayList;
import java.util.Collection;

public class InterfaceTypeTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        ArrayList main = new ArrayList();
        ArrayList ext = new ArrayList();
        doc.getDefinitionsOfType(InterfaceTypeDefinition.class).forEach(i -> {
            if (i.getClass() == InterfaceTypeDefinition.class) {
                main.add(i);
            } else if (i.getClass() == InterfaceTypeExtensionDefinition.class) {
                ext.add((InterfaceTypeExtensionDefinition)i);
            }
        });
        this.populate(ctx, main);
        this.populate(ctx, ext);
    }

    private void populate(GqlContext ctx, Collection<? extends InterfaceTypeDefinition> definitions) {
        definitions.forEach(definition -> ctx.getInterfaceTypes().merge(definition.getName(), GqlStructure.of(definition, ctx::applyNaming), GqlStructure::merge));
    }
}

