/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.io.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.io.translator.Translator;
import graphql.language.Document;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import java.util.ArrayList;
import java.util.Collection;

public class ObjectTypeTranslator
implements Translator {
    @Override
    public void translate(Document doc, GqlContext ctx) {
        ArrayList main = new ArrayList();
        ArrayList ext = new ArrayList();
        doc.getDefinitionsOfType(ObjectTypeDefinition.class).forEach(i -> {
            if (i.getClass() == ObjectTypeDefinition.class) {
                main.add(i);
            } else if (i.getClass() == ObjectTypeExtensionDefinition.class) {
                ext.add((ObjectTypeExtensionDefinition)i);
            }
        });
        this.populate(ctx, main);
        this.populate(ctx, ext);
    }

    private void populate(GqlContext ctx, Collection<? extends ObjectTypeDefinition> definitions) {
        definitions.forEach(definition -> ctx.getObjectTypes().merge(definition.getName(), GqlStructure.of(definition, ctx::applyNaming), GqlStructure::merge));
    }
}

