/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.io.translator;

import com.github.alme.graphql.generator.dto.GqlContext;
import com.github.alme.graphql.generator.dto.GqlField;
import com.github.alme.graphql.generator.dto.GqlOperation;
import com.github.alme.graphql.generator.dto.GqlSelection;
import com.github.alme.graphql.generator.dto.GqlStructure;
import com.github.alme.graphql.generator.dto.GqlType;
import com.github.alme.graphql.generator.io.Util;
import com.github.alme.graphql.generator.io.translator.Translator;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;

public class OperationTranslator
implements Translator {
    private static final String SUFFIX = "Result";
    private static final String UNNAMED = "Unnamed";
    private static final String FRAGMENTS_KEY = "fragments";
    private static final String OPERATION_KEY = "o";
    private static final String OPERATION_DOCUMENT = "OPERATION_DOCUMENT";
    private final Configuration freemarker = new Configuration(Configuration.VERSION_2_3_32);

    public OperationTranslator() {
        this.freemarker.setClassLoaderForTemplateLoading(OperationTranslator.class.getClassLoader(), "/templates/text");
        this.freemarker.setDefaultEncoding(StandardCharsets.UTF_8.displayName());
        this.freemarker.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarker.setLogTemplateExceptions(false);
        this.freemarker.setWrapUncheckedExceptions(true);
        this.freemarker.setFallbackOnNullLoopVariable(false);
    }

    @Override
    public void translate(Document doc, GqlContext ctx) {
        List operations = doc.getDefinitionsOfType(OperationDefinition.class);
        List allFragments = doc.getDefinitionsOfType(FragmentDefinition.class);
        this.populate(ctx, operations, allFragments);
    }

    private void populate(GqlContext ctx, Collection<OperationDefinition> definitions, Collection<FragmentDefinition> allFragments) {
        definitions.forEach(definition -> {
            String operationName = definition.getOperation().name().toLowerCase();
            String typeName = ctx.getOperations().get(operationName);
            if (typeName != null) {
                String definitionName = definition.getName();
                String baseName = this.getOperationBaseName(definitionName, operationName);
                HashSet requiredFragments = new HashSet();
                ctx.getDefinedSelections().computeIfAbsent(baseName, x -> this.traverseSelections(typeName, definition.getSelectionSet(), allFragments, requiredFragments, ctx));
                ctx.getDefinedOperations().computeIfAbsent(baseName, x -> GqlOperation.of(definitionName, operationName, typeName + SUFFIX, this.getDocumentString((OperationDefinition)definition, requiredFragments, ctx.getLog()), definition.getVariableDefinitions().stream().map(v -> GqlField.of(v, ctx::applyNaming)).collect(Collectors.toSet())));
            }
        });
    }

    private String getOperationBaseName(String definitionName, String operationName) {
        return (definitionName == null ? UNNAMED : Util.firstUpper(definitionName)) + Util.firstUpper(operationName);
    }

    private Map<String, Collection<GqlSelection>> traverseSelections(String typeName, SelectionSet subset, Collection<FragmentDefinition> allFragments, Collection<FragmentDefinition> requiredFragments, GqlContext ctx) {
        HashMap<String, Map> typeMap = new HashMap<String, Map>();
        HashMap counters = new HashMap();
        LinkedList<GqlSelection> selectionsToResolve = new LinkedList<GqlSelection>();
        selectionsToResolve.offer(GqlSelection.of(typeName, subset));
        while (!selectionsToResolve.isEmpty()) {
            GqlSelection currentSelection = (GqlSelection)selectionsToResolve.poll();
            String currentTypeName = currentSelection.getType().getName();
            Set subSelections = currentSelection.getSubsets().stream().flatMap(unresolved -> OperationTranslator.resolveOneLevel(unresolved, allFragments, requiredFragments, new HashSet<FragmentDefinition>(), ctx, currentTypeName).stream()).collect(Collectors.toSet());
            Map variants2 = typeMap.computeIfAbsent(currentTypeName, x -> new HashMap());
            int variantNumber = variants2.entrySet().stream().filter(entry -> ((Set)entry.getValue()).equals(subSelections)).map(Map.Entry::getKey).findAny().orElseGet(() -> {
                int key = counters.computeIfAbsent(currentTypeName, x -> new AtomicInteger()).incrementAndGet();
                variants2.put(key, subSelections);
                subSelections.stream().filter(s -> !s.getSubsets().isEmpty()).forEach(selectionsToResolve::offer);
                return key;
            });
            currentSelection.setTargetTypeName(currentTypeName + OperationTranslator.getTypeSuffix(variantNumber));
        }
        HashMap<String, Collection<GqlSelection>> result = new HashMap<String, Collection<GqlSelection>>();
        typeMap.forEach((type, variants) -> variants.forEach((variantNumber, selections) -> result.put(type + OperationTranslator.getTypeSuffix(variantNumber), (Collection<GqlSelection>)selections)));
        return result;
    }

    @NotNull
    private static String getTypeSuffix(int ordinalNumber) {
        return SUFFIX + (ordinalNumber < 2 ? "" : Integer.valueOf(ordinalNumber));
    }

    private static Collection<GqlSelection> resolveOneLevel(SelectionSet selectionSet, Collection<FragmentDefinition> allFragments, Collection<FragmentDefinition> requiredFragments, Collection<FragmentDefinition> visitedFragments, GqlContext ctx, String typeName) {
        HashMap result = new HashMap();
        selectionSet.getSelectionsOfType(Field.class).stream().map(field -> GqlSelection.of(OperationTranslator.findField(field.getName(), ctx, typeName), field.getAlias(), field.getSelectionSet())).forEach(selection -> result.merge(selection.getKey(), selection, GqlSelection::merge));
        selectionSet.getSelectionsOfType(InlineFragment.class).stream().map(fragment -> OperationTranslator.resolveOneLevel(fragment.getSelectionSet(), allFragments, requiredFragments, visitedFragments, ctx, fragment.getTypeCondition().getName())).flatMap(Collection::stream).forEach(selection -> result.merge(selection.getKey(), selection, GqlSelection::merge));
        selectionSet.getSelectionsOfType(FragmentSpread.class).stream().map(FragmentSpread::getName).map(fragmentName -> allFragments.stream().filter(candidate -> Objects.equals(candidate.getName(), fragmentName)).filter(candidate -> OperationTranslator.fragmentMatchesByType(candidate.getTypeCondition().getName(), typeName, ctx)).findAny()).filter(Optional::isPresent).map(Optional::get).filter(visitedFragments::add).map(fragment -> {
            requiredFragments.add((FragmentDefinition)fragment);
            return OperationTranslator.resolveOneLevel(fragment.getSelectionSet(), allFragments, requiredFragments, visitedFragments, ctx, fragment.getTypeCondition().getName());
        }).flatMap(Collection::stream).forEach(selection -> result.merge(selection.getKey(), selection, GqlSelection::merge));
        return result.values();
    }

    private static GqlField findField(String fieldName, GqlContext ctx, String containerTypeName) {
        return Stream.of(ctx.getObjectTypes().get(containerTypeName), ctx.getInterfaceTypes().get(containerTypeName)).filter(Objects::nonNull).map(GqlStructure::getFields).flatMap(Collection::stream).filter(candidate -> Objects.equals(fieldName, candidate.getName())).findAny().orElseGet(() -> GqlField.of(fieldName, GqlType.named("String")));
    }

    private static boolean fragmentMatchesByType(String candidateType, String selectionType, GqlContext ctx) {
        if (Objects.equals(selectionType, candidateType)) {
            return true;
        }
        HashSet<String> candidateTypes = new HashSet<String>();
        candidateTypes.add(candidateType);
        HashSet<String> selectionTypes = new HashSet<String>();
        selectionTypes.add(selectionType);
        ctx.getObjectTypes().values().forEach(typeStructure -> {
            if (typeStructure.getParents().contains(candidateType)) {
                candidateTypes.add(typeStructure.getName());
            }
            if (typeStructure.getParents().contains(selectionType)) {
                selectionTypes.add(typeStructure.getName());
            }
        });
        return !Collections.disjoint(selectionTypes, candidateTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDocumentString(OperationDefinition operation, Collection<FragmentDefinition> fragments, Log log) {
        try {
            String string;
            StringWriter writer = new StringWriter();
            try {
                this.freemarker.setSharedVariable(OPERATION_KEY, (Object)operation);
                this.freemarker.setSharedVariable(FRAGMENTS_KEY, fragments);
                this.freemarker.getTemplate(OPERATION_DOCUMENT).process(null, (Writer)writer);
                string = writer.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (TemplateException | IOException e) {
                    log.warn((CharSequence)String.format("Operation document [%s] is not created.", operation.getName()), e);
                    String string2 = null;
                    return string2;
                }
            }
            writer.close();
            return string;
        }
        finally {
            this.freemarker.clearSharedVariables();
        }
    }
}

