/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.parameters;

import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.parameters.ParameterApplier;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.project.MavenProject;

public class OutputDirectoryParameterApplier
implements ParameterApplier {
    private final MavenProject project;
    private final File outputDirectory;
    private final String packageName;
    private static final String TYPES_SUBPACKAGE = ".types";
    private static final String DYNAMIC_SUBPACKAGE = ".dynamic";

    @Override
    public void apply(GqlConfiguration.GqlConfigurationBuilder builder) {
        builder.outputRoot(this.getOutputDirectory(this.outputDirectory)).operationsPackageName(this.packageName).schemaTypesPackageName(this.packageName + TYPES_SUBPACKAGE).definedOperationsPackageName(this.packageName).dynamicOperationsPackageName(this.packageName + DYNAMIC_SUBPACKAGE);
    }

    private Path getOutputDirectory(File outputDirectory) {
        return outputDirectory == null ? Paths.get(this.project.getBasedir() == null ? "" : this.project.getBuild().getDirectory(), new String[0]).resolve("generated-sources").resolve("graphql-classes").resolve("java") : outputDirectory.toPath();
    }

    public OutputDirectoryParameterApplier(MavenProject project, File outputDirectory, String packageName) {
        this.project = project;
        this.outputDirectory = outputDirectory;
        this.packageName = packageName;
    }
}

