/*
 * Decompiled with CFR 0.152.
 */
package com.github.alme.graphql.generator.parameters;

import com.github.alme.graphql.generator.dto.GqlConfiguration;
import com.github.alme.graphql.generator.parameters.ParameterApplier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class SourceParameterApplier
implements ParameterApplier {
    private final Set<FileSet> sources = new HashSet<FileSet>();
    private final File baseDirectory;
    private static final String LIST_SEPARATOR = ",";

    public SourceParameterApplier(MavenProject project, Collection<FileSet> sources, FileSet source, String sourceDirectoryAlternative, Collection<String> sourceIncludesAlternative, Collection<String> sourceExcludesAlternative) {
        if (sources != null) {
            this.sources.addAll(sources);
        }
        if (source != null) {
            this.sources.add(source);
        }
        if (this.sources.isEmpty()) {
            this.sources.add(SourceParameterApplier.getAlternative(sourceDirectoryAlternative, sourceIncludesAlternative, sourceExcludesAlternative));
        }
        this.baseDirectory = Optional.ofNullable(project.getBasedir()).orElseGet(() -> new File("").getAbsoluteFile());
    }

    private static FileSet getAlternative(String directory, Collection<String> includes, Collection<String> excludes) {
        FileSet source = new FileSet();
        source.setDirectory(directory);
        source.setIncludes(new ArrayList<String>(includes));
        source.setExcludes(new ArrayList<String>(excludes));
        return source;
    }

    @Override
    public void apply(GqlConfiguration.GqlConfigurationBuilder builder) throws MojoExecutionException {
        Set<Path> sourceFiles = this.sources.stream().map(this::getFileNames).flatMap(Collection::stream).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
        if (sourceFiles.isEmpty()) {
            throw new MojoExecutionException("Could not find any source files.");
        }
        builder.sourceFiles(sourceFiles);
    }

    private List<String> getFileNames(FileSet source) {
        try {
            return FileUtils.getFileNames((File)Optional.ofNullable(source.getDirectory()).map(File::new).map(File::getAbsoluteFile).orElse(this.baseDirectory), (String)String.join((CharSequence)LIST_SEPARATOR, source.getIncludes()), (String)String.join((CharSequence)LIST_SEPARATOR, source.getExcludes()), (boolean)true);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not process " + source, e);
        }
    }
}

