/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.pathfinding.CellState;
import com.almasb.fxgl.pathfinding.Pathfinder;
import com.almasb.fxgl.pathfinding.astar.AStarCell;
import com.almasb.fxgl.pathfinding.astar.AStarGrid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AStarPathfinder
implements Pathfinder<AStarCell> {
    private AStarGrid grid;

    public AStarPathfinder(AStarGrid grid) {
        this.grid = grid;
    }

    public AStarGrid getGrid() {
        return this.grid;
    }

    @Override
    public List<AStarCell> findPath(int sourceX, int sourceY, int targetX, int targetY) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), new AStarCell[0]);
    }

    @Override
    public List<AStarCell> findPath(int sourceX, int sourceY, int targetX, int targetY, List<AStarCell> busyCells) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), busyCells.toArray(new AStarCell[0]));
    }

    public List<AStarCell> findPath(AStarCell[][] grid, AStarCell start, AStarCell target, AStarCell ... busyNodes) {
        if (start == target || target.getState() == CellState.NOT_WALKABLE) {
            return Collections.emptyList();
        }
        for (int y = 0; y < grid[0].length; ++y) {
            for (int x = 0; x < grid.length; ++x) {
                grid[x][y].setHCost(Math.abs(target.getX() - x) + Math.abs(target.getY() - y));
                grid[x][y].setParent(null);
                grid[x][y].setGCost(0);
            }
        }
        ArrayList<AStarCell> open = new ArrayList<AStarCell>();
        ArrayList<AStarCell> closed = new ArrayList<AStarCell>();
        AStarCell current = start;
        boolean found = false;
        while (!found && !closed.contains(target)) {
            for (AStarCell neighbor : this.getValidNeighbors(current, grid, busyNodes)) {
                if (neighbor == target) {
                    target.setParent(current);
                    found = true;
                    closed.add(target);
                    break;
                }
                if (closed.contains(neighbor)) continue;
                if (open.contains(neighbor)) {
                    int newG = current.getGCost() + 10;
                    if (newG >= neighbor.getGCost()) continue;
                    neighbor.setParent(current);
                    neighbor.setGCost(newG);
                    continue;
                }
                neighbor.setParent(current);
                neighbor.setGCost(current.getGCost() + 10);
                open.add(neighbor);
            }
            if (found) continue;
            closed.add(current);
            open.remove(current);
            if (open.isEmpty()) {
                return Collections.emptyList();
            }
            AStarCell acc = (AStarCell)open.get(0);
            for (AStarCell a : open) {
                acc = a.getFCost() < acc.getFCost() ? a : acc;
            }
            current = acc;
        }
        return this.buildPath(start, target);
    }

    private List<AStarCell> buildPath(AStarCell start, AStarCell target) {
        ArrayList<AStarCell> path = new ArrayList<AStarCell>();
        AStarCell tmp = target;
        do {
            path.add(tmp);
        } while ((tmp = tmp.getParent()) != start);
        Collections.reverse(path);
        return path;
    }

    protected List<AStarCell> getValidNeighbors(AStarCell node, AStarCell[][] grid, AStarCell ... busyNodes) {
        int x = node.getX();
        int y = node.getY();
        int[] points = new int[]{x - 1, y, x + 1, y, x, y - 1, x, y + 1};
        ArrayList<AStarCell> result = new ArrayList<AStarCell>();
        for (int i = 0; i < points.length; ++i) {
            int x1 = points[i];
            int y1 = points[++i];
            if (x1 < 0 || x1 >= grid.length || y1 < 0 || y1 >= grid[0].length || grid[x1][y1].getState() != CellState.WALKABLE || this.contains(x1, y1, busyNodes)) continue;
            result.add(grid[x1][y1]);
        }
        return result;
    }

    private boolean contains(int x, int y, AStarCell ... cells) {
        for (AStarCell n : cells) {
            if (n.getX() != x || n.getY() != y) continue;
            return true;
        }
        return false;
    }
}

