/*
 * Decompiled with CFR 0.152.
 */
package com.github.andyglow.websocket;

import com.github.andyglow.websocket.MessageAdapter;
import com.github.andyglow.websocket.WebsocketClient;
import com.github.andyglow.websocket.WebsocketHandler;
import com.github.andyglow.websocket.WebsocketHandler$;
import com.github.andyglow.websocket.util.Uri;
import com.github.andyglow.websocket.util.Uri$;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;

public final class WebsocketClient$ {
    public static final WebsocketClient$ MODULE$;
    private final int defaultFramePayloadLength;
    private final FiniteDuration defaultShutdownQuietPeriod;
    private final FiniteDuration defaultShutdownTimeout;

    static {
        new WebsocketClient$();
    }

    public int defaultFramePayloadLength() {
        return this.defaultFramePayloadLength;
    }

    public FiniteDuration defaultShutdownQuietPeriod() {
        return this.defaultShutdownQuietPeriod;
    }

    public FiniteDuration defaultShutdownTimeout() {
        return this.defaultShutdownTimeout;
    }

    public <T> WebsocketClient<T> apply(String uri, PartialFunction<T, BoxedUnit> receive2, MessageAdapter<T> evidence$2) {
        return this.apply(Uri$.MODULE$.apply(uri), WebsocketHandler$.MODULE$.apply(receive2, WebsocketHandler$.MODULE$.apply$default$2(), WebsocketHandler$.MODULE$.apply$default$3(), evidence$2), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9(), evidence$2);
    }

    public <T> WebsocketClient<T> apply(Uri uri, PartialFunction<T, BoxedUnit> receive2, MessageAdapter<T> evidence$3) {
        return this.apply(uri, WebsocketHandler$.MODULE$.apply(receive2, WebsocketHandler$.MODULE$.apply$default$2(), WebsocketHandler$.MODULE$.apply$default$3(), evidence$3), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9(), evidence$3);
    }

    public <T> WebsocketClient<T> apply(Uri uri, WebsocketHandler<T> handler, Map<String, String> headers, Option<LogLevel> logLevel, Option<String> subprotocol, Option<SslContext> maybeSslCtx, int maxFramePayloadLength, FiniteDuration shutdownQuietPeriod, FiniteDuration shutdownTimeout, MessageAdapter<T> evidence$7) {
        Predef$.MODULE$.require(shutdownTimeout.$greater$eq((Object)shutdownQuietPeriod), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "It is required that shutdownTimeout is >= shutdownQuietPeriod";
            }
        });
        None$ sslCtx = uri.secure() ? maybeSslCtx.orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<SslContext> apply() {
                return new Some((Object)SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
            }
        }) : None$.MODULE$;
        HttpHeaders customHeaders = (HttpHeaders)headers.foldLeft((Object)new DefaultHttpHeaders(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HttpHeaders apply(HttpHeaders x0$1, Tuple2<String, String> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                if (tuple2 != null) {
                    HttpHeaders headers = (HttpHeaders)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        HttpHeaders httpHeaders = headers.add(k, (Object)v);
                        return httpHeaders;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        return new WebsocketClient<T>(uri, subprotocol, (Option<SslContext>)sslCtx, customHeaders, handler, logLevel, maxFramePayloadLength, shutdownQuietPeriod, shutdownTimeout, evidence$7);
    }

    public <T> Map<String, String> apply$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public <T> Option<LogLevel> apply$default$4() {
        return None$.MODULE$;
    }

    public <T> Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public <T> Option<SslContext> apply$default$6() {
        return None$.MODULE$;
    }

    public <T> int apply$default$7() {
        return this.defaultFramePayloadLength();
    }

    public <T> FiniteDuration apply$default$8() {
        return this.defaultShutdownQuietPeriod();
    }

    public <T> FiniteDuration apply$default$9() {
        return this.defaultShutdownTimeout();
    }

    private WebsocketClient$() {
        MODULE$ = this;
        this.defaultFramePayloadLength = 65536;
        this.defaultShutdownQuietPeriod = new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds();
        this.defaultShutdownTimeout = new package.DurationInt(package$.MODULE$.DurationInt(13)).seconds();
    }
}

