/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.assertion.cucumber;

import com.github.angleshq.angles.assertion.AssertHelper;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public class AnglesJUnitAssert {
    public void assertTrue(boolean condition) {
        AssertHelper.handleAssertEquals((String)"AssertTrue", (Object)true, (Object)condition);
        Assert.assertTrue((boolean)condition);
    }

    public void assertTrue(boolean condition, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertTrue", (Object)true, (Object)condition, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertTrue((String)messageSupplier.get(), (boolean)condition);
    }

    public void assertTrue(BooleanSupplier booleanSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertTrue", (Object)true, (Object)booleanSupplier.getAsBoolean());
        Assert.assertTrue((boolean)booleanSupplier.getAsBoolean());
    }

    public void assertTrue(BooleanSupplier booleanSupplier, String message) {
        AssertHelper.handleAssertEquals((String)"AssertTrue", (Object)true, (Object)booleanSupplier.getAsBoolean(), (String)message);
        Assert.assertTrue((String)message, (boolean)booleanSupplier.getAsBoolean());
    }

    public void assertTrue(boolean condition, String message) {
        AssertHelper.handleAssertEquals((String)"AssertTrue", (Object)true, (Object)condition, (String)message);
        Assert.assertTrue((String)message, (boolean)condition);
    }

    public void assertTrue(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertTrue", (Object)true, (Object)booleanSupplier.getAsBoolean(), (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertTrue((String)messageSupplier.get(), (boolean)booleanSupplier.getAsBoolean());
    }

    public void assertFalse(boolean condition) {
        AssertHelper.handleAssertEquals((String)"AssertFalse", (Object)false, (Object)condition);
        Assert.assertFalse((boolean)condition);
    }

    public void assertFalse(boolean condition, String message) {
        AssertHelper.handleAssertEquals((String)"AssertFalse", (Object)false, (Object)condition, (String)message);
        Assert.assertFalse((String)message, (boolean)condition);
    }

    public void assertFalse(boolean condition, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertFalse", (Object)false, (Object)condition, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertFalse((String)messageSupplier.get(), (boolean)condition);
    }

    public void assertFalse(BooleanSupplier booleanSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertFalse", (Object)false, (Object)booleanSupplier.getAsBoolean());
        Assert.assertFalse((boolean)booleanSupplier.getAsBoolean());
    }

    public void assertFalse(BooleanSupplier booleanSupplier, String message) {
        AssertHelper.handleAssertEquals((String)"AssertFalse", (Object)false, (Object)booleanSupplier.getAsBoolean(), (String)message);
        Assert.assertFalse((String)message, (boolean)booleanSupplier.getAsBoolean());
    }

    public void assertFalse(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertFalse", (Object)false, (Object)booleanSupplier.getAsBoolean(), (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertFalse((String)messageSupplier.get(), (boolean)booleanSupplier.getAsBoolean());
    }

    public void assertNull(Object actual) {
        AssertHelper.handleAssertNull((String)"AssertNull", (Object)actual);
        Assert.assertNull((Object)actual);
    }

    public void assertNull(Object actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertNull", null, (Object)actual, (String)message);
        Assert.assertNull((String)message, (Object)actual);
    }

    public void assertNull(Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertNull", null, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNull((String)messageSupplier.get(), (Object)actual);
    }

    public void assertNotNull(Object actual) {
        AssertHelper.handleAssertNotNull((String)"AssertNotNull", (Object)actual);
        Assert.assertNotNull((Object)actual);
    }

    public void assertNotNull(Object actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotNull", null, (Object)actual, (String)message);
        Assert.assertNotNull((String)message, (Object)actual);
    }

    public void assertNotNull(Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotNull", null, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotNull((String)messageSupplier.get(), (Object)actual);
    }

    public void assertEquals(String expected, String actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (String/String)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(String expected, String actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (String/String)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(String expected, String actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (String/String)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, boolean actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean/boolean)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, Boolean actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean/Boolean)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, short actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Boolean/short)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, Boolean actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Boolean/Boolean)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, boolean actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean/boolean)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, Boolean actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean/Boolean)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, boolean actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Boolean/boolean)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, Boolean actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Boolean/Boolean)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean/boolean)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, Boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean/Boolean)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Boolean/boolean)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, Boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Boolean/Boolean)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(Short expected, Short actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Short/Short)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(Short expected, Short actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Short/Short)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(short expected, short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (short/short)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (long)expected, (long)actual);
    }

    public void assertEquals(Short expected, Short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Short/Short)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(Byte expected, Byte actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Byte/Byte)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(byte expected, byte actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (byte/byte)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (long)expected, (long)actual);
    }

    public void assertEquals(Byte expected, Byte actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Byte/Byte)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(byte expected, byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (byte/byte)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (long)expected, (long)actual);
    }

    public void assertEquals(Byte expected, Byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Byte/Byte)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(int expected, int actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (int/int)", (Object)expected, (Object)actual);
        Assert.assertEquals((long)expected, (long)actual);
    }

    public void assertEquals(Integer expected, Integer actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Integer/Integer)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(int expected, int actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (int/int)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (long)expected, (long)actual);
    }

    public void assertEquals(Integer expected, Integer actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Integer/Integer)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(int expected, int actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (int/int)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (long)expected, (long)actual);
    }

    public void assertEquals(Integer expected, Integer actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Integer/Integer)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(long expected, long actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (long/long)", (Object)expected, (Object)actual);
        Assert.assertEquals((long)expected, (long)actual);
    }

    public void assertEquals(Long expected, Long actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Long/Long)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(long expected, long actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (long/long)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (long)expected, (long)actual);
    }

    public void assertEquals(Long expected, Long actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Long/Long)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(long expected, long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (long/long)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (long)expected, (long)actual);
    }

    public void assertEquals(Long expected, Long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Long/Long)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(float expected, float actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (float/float)", (Object)Float.valueOf(expected), (Object)Float.valueOf(actual));
        Assert.assertEquals((double)expected, (double)actual);
    }

    public void assertEquals(Float expected, Float actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Float/Float)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(float expected, float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (float/float)", (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (double)expected, (double)actual);
    }

    public void assertEquals(Float expected, Float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Float/Float)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(double expected, double actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (double/double)", (Object)expected, (Object)actual);
        Assert.assertEquals((double)expected, (double)actual);
    }

    public void assertEquals(Double expected, Double actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Double/Double)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(double expected, double actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (double/double)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (double)expected, (double)actual);
    }

    public void assertEquals(Double expected, Double actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Double/Double)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(double expected, double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (double/double)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (double)expected, (double)actual);
    }

    public void assertEquals(Double expected, Double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Double/Double)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(char expected, char actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (char/char)", (Object)Character.valueOf(expected), (Object)Character.valueOf(actual));
        Assert.assertEquals((long)expected, (long)actual);
    }

    public void assertEquals(Character expected, Character actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Character/Character)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(char expected, char actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (char/char)", (Object)Character.valueOf(expected), (Object)Character.valueOf(actual), (String)message);
        Assert.assertEquals((String)message, (long)expected, (long)actual);
    }

    public void assertEquals(Character expected, Character actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Character/Character)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(char expected, char actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (char/char)", (Object)Character.valueOf(expected), (Object)Character.valueOf(actual), (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (long)expected, (long)actual);
    }

    public void assertEquals(Character expected, Character actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Character/Character)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertEquals(Object expected, Object actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Object/Object)", (Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(Object expected, Object actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Object/Object)", (Object)expected, (Object)actual, (String)message);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(Object expected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Object/Object)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertArrayEquals(boolean[] expected, boolean[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean[]/boolean[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((boolean[])expected, (boolean[])actual);
    }

    public void assertArrayEquals(boolean[] expected, boolean[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean[]/boolean[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (boolean[])expected, (boolean[])actual);
    }

    public void assertArrayEquals(boolean[] expected, boolean[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (boolean[]/boolean[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (boolean[])expected, (boolean[])actual);
    }

    public void assertArrayEquals(char[] expected, char[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (char[]/char[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((char[])expected, (char[])actual);
    }

    public void assertArrayEquals(char[] expected, char[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (char[]/char[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (char[])expected, (char[])actual);
    }

    public void assertArrayEquals(char[] expected, char[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (char[]/char[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (char[])expected, (char[])actual);
    }

    public void assertArrayEquals(byte[] expected, byte[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (byte[]/byte[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    public void assertArrayEquals(byte[] expected, byte[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (byte[]/byte[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (byte[])expected, (byte[])actual);
    }

    public void assertArrayEquals(byte[] expected, byte[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (byte[]/byte[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (byte[])expected, (byte[])actual);
    }

    public void assertArrayEquals(short[] expected, short[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (short[]/short[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((short[])expected, (short[])actual);
    }

    public void assertArrayEquals(short[] expected, short[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (short[]/short[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (short[])expected, (short[])actual);
    }

    public void assertArrayEquals(short[] expected, short[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (short[]/short[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (short[])expected, (short[])actual);
    }

    public void assertArrayEquals(int[] expected, int[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (int[]/int[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((int[])expected, (int[])actual);
    }

    public void assertArrayEquals(int[] expected, int[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (int[]/int[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (int[])expected, (int[])actual);
    }

    public void assertArrayEquals(int[] expected, int[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (int[]/int[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (int[])expected, (int[])actual);
    }

    public void assertArrayEquals(long[] expected, long[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (long[]/long[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((long[])expected, (long[])actual);
    }

    public void assertArrayEquals(long[] expected, long[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (long[]/long[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (long[])expected, (long[])actual);
    }

    public void assertArrayEquals(long[] expected, long[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (long[]/long[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (long[])expected, (long[])actual);
    }

    public void assertArrayEquals(double[] expected, double[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (double[]/double[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((double[])expected, (double[])actual, (double)0.0);
    }

    public void assertArrayEquals(double[] expected, double[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (double[]/double[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (double[])expected, (double[])actual, (double)0.0);
    }

    public void assertArrayEquals(double[] expected, double[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (double[]/double[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (double[])expected, (double[])actual, (double)0.0);
    }

    public void assertArrayEquals(Object[] expected, Object[] actual) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Object[]/Object[])", (Object)expected, (Object)actual);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    public void assertArrayEquals(Object[] expected, Object[] actual, String message) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Object[]/Object[])", (Object)expected, (Object)actual, (String)message);
        Assert.assertArrayEquals((String)message, (Object[])expected, (Object[])actual);
    }

    public void assertArrayEquals(Object[] expected, Object[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals((String)"AssertEquals (Object[]/Object[])", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertArrayEquals((String)messageSupplier.get(), (Object[])expected, (Object[])actual);
    }

    public void assertNotEquals(byte unexpected, byte actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (byte/byte)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((long)unexpected, (long)actual);
    }

    public void assertNotEquals(Byte unexpected, Byte actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Byte/Byte)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(byte unexpected, byte actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (byte/byte)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Byte unexpected, Byte actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Byte/Byte)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(byte unexpected, byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (byte/byte)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Byte unexpected, Byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Byte/Byte)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(short unexpected, short actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (short/short)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((long)unexpected, (long)actual);
    }

    public void assertNotEquals(Short unexpected, Short actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Short/Short)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(short unexpected, short actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (short/short)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Short unexpected, Short actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Short/Short)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(short unexpected, short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (short/short)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Short unexpected, Short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Short/Short)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(int unexpected, int actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (int/int)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((long)unexpected, (long)actual);
    }

    public void assertNotEquals(Integer unexpected, Integer actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Integer/Integer)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(int unexpected, int actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (int/int)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Integer unexpected, Integer actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Integer/Integer)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(int unexpected, int actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (int/int)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Integer unexpected, Integer actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Integer/Integer)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(long unexpected, long actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (long/long)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((long)unexpected, (long)actual);
    }

    public void assertNotEquals(long unexpected, long actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (long/long)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Long unexpected, Long actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Long/Long)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(long unexpected, long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (long/long)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Long unexpected, Long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Long/Long)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(float unexpected, float actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (float/float)", (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual));
        Assert.assertNotEquals((Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual));
    }

    public void assertNotEquals(float unexpected, Float actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (float/Float)", (Object)Float.valueOf(unexpected), (Object)actual);
        Assert.assertNotEquals((Object)Float.valueOf(unexpected), (Object)actual);
    }

    public void assertNotEquals(Float unexpected, float actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Float/float)", (Object)unexpected, (Object)Float.valueOf(actual));
        Assert.assertNotEquals((Object)unexpected, (Object)Float.valueOf(actual));
    }

    public void assertNotEquals(Float unexpected, Float actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Float/Float)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(float unexpected, float actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (float/float)", (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual), (String)message);
        Assert.assertNotEquals((String)message, (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual));
    }

    public void assertNotEquals(float unexpected, Float actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (float/Float)", (Object)Float.valueOf(unexpected), (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)Float.valueOf(unexpected), (Object)actual);
    }

    public void assertNotEquals(Float unexpected, float actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Float/float)", (Object)unexpected, (Object)Float.valueOf(actual), (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)Float.valueOf(actual));
    }

    public void assertNotEquals(Float unexpected, Float actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Float/Float)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(float unexpected, float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (float/float)", (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual), (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual));
    }

    public void assertNotEquals(float unexpected, Float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (float/Float)", (Object)Float.valueOf(unexpected), (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)Float.valueOf(unexpected), (Object)actual);
    }

    public void assertNotEquals(Float unexpected, float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Float/float)", (Object)unexpected, (Object)Float.valueOf(actual), (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)Float.valueOf(actual));
    }

    public void assertNotEquals(Float unexpected, Float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Float/Float)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(double unexpected, double actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (double/double)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(double unexpected, Double actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (double/Double)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Double unexpected, double actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Double/double)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Double unexpected, Double actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Double/Double)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(double unexpected, double actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (double/double)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(double unexpected, Double actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (double/Double)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Double unexpected, double actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Double/double)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Double unexpected, Double actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Double/Double)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(double unexpected, double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (double/double)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(double unexpected, Double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (double/Double)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Double unexpected, double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Double/double)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Double unexpected, Double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Double/Double)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(char unexpected, char actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (char/char)", (Object)Character.valueOf(unexpected), (Object)Character.valueOf(actual));
        Assert.assertNotEquals((long)unexpected, (long)actual);
    }

    public void assertNotEquals(Character unexpected, Character actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Character/Character)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(char unexpected, char actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (char/char)", (Object)Character.valueOf(unexpected), (Object)Character.valueOf(actual), (String)message);
        Assert.assertNotEquals((String)message, (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Character unexpected, Character actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Character/Character)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(char unexpected, char actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (char/char)", (Object)Character.valueOf(unexpected), (Object)Character.valueOf(actual), (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (long)unexpected, (long)actual);
    }

    public void assertNotEquals(Character unexpected, Character actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Character/Character)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Object unexpected, Object actual) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Object/Object)", (Object)unexpected, (Object)actual);
        Assert.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Object unexpected, Object actual, String message) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Object/Object)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals((String)"AssertNotEquals (Object/Object)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotEquals((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertSame(Object expected, Object actual) {
        AssertHelper.handleAssertSame((String)"AssertSame (Object/Object)", (Object)expected, (Object)actual);
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public void assertSame(Object expected, Object actual, String message) {
        AssertHelper.handleAssertSame((String)"AssertSame (Object/Object)", (Object)expected, (Object)actual, (String)message);
        Assert.assertSame((String)message, (Object)expected, (Object)actual);
    }

    public void assertSame(Object expected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertSame((String)"AssertSame (Object/Object)", (Object)expected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertSame((String)messageSupplier.get(), (Object)expected, (Object)actual);
    }

    public void assertNotSame(Object unexpected, Object actual) {
        AssertHelper.handleAssertNotSame((String)"AssertNotSame (Object/Object)", (Object)unexpected, (Object)actual);
        Assert.assertNotSame((Object)unexpected, (Object)actual);
    }

    public void assertNotSame(Object unexpected, Object actual, String message) {
        AssertHelper.handleAssertNotSame((String)"AssertNotSame (Object/Object)", (Object)unexpected, (Object)actual, (String)message);
        Assert.assertNotSame((String)message, (Object)unexpected, (Object)actual);
    }

    public void assertNotSame(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotSame((String)"AssertNotSame (Object/Object)", (Object)unexpected, (Object)actual, (String)this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assert.assertNotSame((String)messageSupplier.get(), (Object)unexpected, (Object)actual);
    }

    public void assertGreaterThan(Double value1, Double value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan((Double)value1, (Double)value2));
    }

    public void assertLessThan(Double value1, Double value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan((Double)value1, (Double)value2));
    }

    public void assertGreaterThan(Integer value1, Integer value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan((Integer)value1, (Integer)value2));
    }

    public void assertLessThan(Integer value1, Integer value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan((Integer)value1, (Integer)value2));
    }

    public void assertGreaterThan(Float value1, Float value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan((Float)value1, (Float)value2));
    }

    public void assertLessThan(Float value1, Float value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan((Float)value1, (Float)value2));
    }

    public void assertGreaterThan(String value1, String value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan((String)value1, (String)value2));
    }

    public void assertLessThan(String value1, String value2) {
        Assert.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan((String)value1, (String)value2));
    }

    private String buildPrefix(String message) {
        return StringUtils.isNotBlank((CharSequence)message) ? message + " ==> " : "";
    }

    private String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

