/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.listeners.cucumber;

import com.github.angleshq.angles.assertion.cucumber.AnglesJUnitAssert;
import com.github.angleshq.angles.basetest.AbstractAnglesTestCase;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepStarted;
import java.util.List;

public class AnglesCucumberAdapter
extends AbstractAnglesTestCase
implements ConcurrentEventListener {
    protected AnglesJUnitAssert doAssert = new AnglesJUnitAssert();
    protected EventHandler<TestStepStarted> handleTestStepFinished = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            TestStep testStep = event.getTestStep();
            if (testStep.getClass().getName().equals("io.cucumber.core.runner.PickleStepTestStep")) {
                PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
                AnglesCucumberAdapter.this.anglesReporter.startAction(pickleStepTestStep.getStep().getKeyword() + pickleStepTestStep.getStep().getText());
                AnglesCucumberAdapter.this.anglesReporter.info("Starting step: " + pickleStepTestStep.getStep().getText());
                String argumentTable = "";
                try {
                    DataTableArgument argument = (DataTableArgument)pickleStepTestStep.getStep().getArgument();
                    if (argument != null) {
                        List cells = argument.cells();
                        for (List row : argument.cells()) {
                            argumentTable = argumentTable + "DataTable: \n| ";
                            for (String value : row) {
                                argumentTable = argumentTable + value + " | ";
                            }
                        }
                        AnglesCucumberAdapter.this.anglesReporter.info(argumentTable);
                    }
                }
                catch (Exception e) {
                    AnglesCucumberAdapter.this.anglesReporter.info("Cannot show argument table: " + e.getMessage());
                }
            } else {
                String hookName = testStep.toString();
                if (hookName.equals("Before")) {
                    AnglesCucumberAdapter.this.anglesReporter.startAction("Setup");
                    AnglesCucumberAdapter.this.anglesReporter.info(hookName);
                } else if (hookName.equals("After")) {
                    AnglesCucumberAdapter.this.anglesReporter.startAction("Cleanup");
                    AnglesCucumberAdapter.this.anglesReporter.info(hookName);
                }
            }
        }
    };
    protected EventHandler<TestCaseStarted> handleTestCaseStarted = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            String[] featurePath = event.getTestCase().getScenarioDesignation().split(":");
            String featureName = featurePath[0];
            featurePath = featureName.split("/");
            featureName = featurePath[featurePath.length - 1];
            String testName = event.getTestCase().getName();
            AnglesCucumberAdapter.this.anglesReporter.startTest(featureName, testName);
        }
    };
    protected EventHandler<TestCaseFinished> handleTestCaseFinished = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            TestCase testCase = event.getTestCase();
            Result result = event.getResult();
            String scenarioName = testCase.getName();
            if (result.getStatus().equals((Object)Status.PASSED)) {
                AnglesCucumberAdapter.this.anglesReporter.pass(scenarioName + " passed!", "", "", "");
            }
            if (result.getStatus().equals((Object)Status.FAILED)) {
                AnglesCucumberAdapter.this.anglesReporter.fail(scenarioName + " failed!", "", event.getResult().getError().getMessage(), "Test has failed");
            }
            if (result.getStatus().equals((Object)Status.SKIPPED)) {
                AnglesCucumberAdapter.this.anglesReporter.fail(scenarioName + " skipped!", "", "", "Test NOT RUN");
            }
            AnglesCucumberAdapter.this.anglesReporter.saveTest();
        }
    };

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.handleTestCaseFinished);
        publisher.registerHandlerFor(TestCaseStarted.class, this.handleTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this.handleTestStepFinished);
    }
}

