/*
 * Decompiled with CFR 0.152.
 */
package com.github.anicolaspp.ojai;

import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.ojai.store.impl.Values;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.MutationOp;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class InMemoryMutation
extends MutationImpl {
    private List<MutationOp> ops = new ArrayList<MutationOp>();

    private void newOp(String string, Value value, MutationOp.Type type) {
        MutationOp mutationOp = new MutationOp();
        mutationOp.setFieldPath(FieldPath.parseFrom((String)string));
        mutationOp.setOpValue(value);
        mutationOp.setType(type);
        this.ops.add(mutationOp);
    }

    private void nullOp(String string) {
        MutationOp mutationOp = new MutationOp();
        mutationOp.setFieldPath(FieldPath.parseFrom((String)string));
        mutationOp.setOpValue(null);
        this.ops.add(mutationOp);
    }

    public DocumentMutation setNull(String string) {
        this.nullOp(string);
        return super.setNull(string);
    }

    public DocumentMutation setNull(FieldPath fieldPath) {
        this.nullOp(fieldPath.asPathString());
        return super.setNull(fieldPath);
    }

    public DocumentMutation set(String string, Value value) {
        return super.set(string, value);
    }

    public DocumentMutation set(FieldPath fieldPath, Value value) {
        this.newOp(fieldPath.asPathString(), value, MutationOp.Type.SET);
        return super.set(fieldPath, value);
    }

    public DocumentMutation set(String string, boolean bl) {
        return super.set(string, bl);
    }

    public DocumentMutation set(FieldPath fieldPath, boolean bl) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.BooleanValue(bl), MutationOp.Type.SET);
        return super.set(fieldPath, bl);
    }

    public DocumentMutation set(String string, short s) {
        return super.set(string, s);
    }

    public DocumentMutation set(FieldPath fieldPath, short s) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.ShortValue(s), MutationOp.Type.SET);
        return super.set(fieldPath, s);
    }

    public DocumentMutation set(String string, byte by) {
        return super.set(string, by);
    }

    public DocumentMutation set(FieldPath fieldPath, byte by) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.ByteValue(by), MutationOp.Type.SET);
        return super.set(fieldPath, by);
    }

    public DocumentMutation set(String string, int n) {
        return super.set(string, n);
    }

    public DocumentMutation set(FieldPath fieldPath, int n) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.IntValue(n), MutationOp.Type.SET);
        return super.set(fieldPath, n);
    }

    public DocumentMutation set(String string, long l) {
        return super.set(string, l);
    }

    public DocumentMutation set(FieldPath fieldPath, long l) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.LongValue(l), MutationOp.Type.SET);
        return super.set(fieldPath, l);
    }

    public DocumentMutation set(String string, float f) {
        return super.set(string, f);
    }

    public DocumentMutation set(FieldPath fieldPath, float f) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.FloatValue(f), MutationOp.Type.SET);
        return super.set(fieldPath, f);
    }

    public DocumentMutation set(String string, double d) {
        return super.set(string, d);
    }

    public DocumentMutation set(FieldPath fieldPath, double d) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.DoubleValue(d), MutationOp.Type.SET);
        return super.set(fieldPath, d);
    }

    public MutationImpl set(String string, String string2) {
        return super.set(string, string2);
    }

    public MutationImpl set(FieldPath fieldPath, String string) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.StringValue(string), MutationOp.Type.SET);
        return super.set(fieldPath, string);
    }

    public DocumentMutation set(String string, BigDecimal bigDecimal) {
        return super.set(string, bigDecimal);
    }

    public DocumentMutation set(FieldPath fieldPath, BigDecimal bigDecimal) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.DoubleValue(bigDecimal.doubleValue()), MutationOp.Type.SET);
        return super.set(fieldPath, bigDecimal);
    }

    public DocumentMutation set(String string, OTime oTime) {
        return super.set(string, oTime);
    }

    public DocumentMutation set(FieldPath fieldPath, OTime oTime) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.TimeValue(oTime), MutationOp.Type.SET);
        return super.set(fieldPath, oTime);
    }

    public DocumentMutation set(String string, OTimestamp oTimestamp) {
        return super.set(string, oTimestamp);
    }

    public DocumentMutation set(FieldPath fieldPath, OTimestamp oTimestamp) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.TimestampValue(oTimestamp), MutationOp.Type.SET);
        return super.set(fieldPath, oTimestamp);
    }

    public DocumentMutation set(String string, ODate oDate) {
        return super.set(string, oDate);
    }

    public DocumentMutation set(FieldPath fieldPath, ODate oDate) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.TimeValue(new OTime(oDate.toDate())), MutationOp.Type.SET);
        return super.set(fieldPath, oDate);
    }

    public DocumentMutation set(String string, List<?> list) {
        return super.set(string, list);
    }

    public DocumentMutation set(FieldPath fieldPath, List<?> list) {
        return super.set(fieldPath, list);
    }

    public DocumentMutation set(String string, OInterval oInterval) {
        return super.set(string, oInterval);
    }

    public DocumentMutation set(FieldPath fieldPath, OInterval oInterval) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.IntervalValue(oInterval), MutationOp.Type.SET);
        return super.set(fieldPath, oInterval);
    }

    public DocumentMutation set(String string, ByteBuffer byteBuffer) {
        return super.set(string, byteBuffer);
    }

    public DocumentMutation set(FieldPath fieldPath, ByteBuffer byteBuffer) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.BinaryValue(byteBuffer), MutationOp.Type.SET);
        return super.set(fieldPath, byteBuffer);
    }

    public DocumentMutation set(String string, Map<String, ?> map) {
        return super.set(string, map);
    }

    public DocumentMutation set(FieldPath fieldPath, Map<String, ?> map) {
        return super.set(fieldPath, map);
    }

    public DocumentMutation set(String string, Document document) {
        return super.set(string, document);
    }

    public DocumentMutation set(FieldPath fieldPath, Document document) {
        return super.set(fieldPath, document);
    }

    public DocumentMutation setOrReplace(String string, Value value) {
        return super.setOrReplace(string, value);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, Value value) {
        this.newOp(fieldPath.asPathString(), value, MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, value);
    }

    public DocumentMutation setOrReplaceNull(String string) {
        return this.setNull(string);
    }

    public DocumentMutation setOrReplaceNull(FieldPath fieldPath) {
        return this.setNull(fieldPath.asPathString());
    }

    public DocumentMutation setOrReplace(String string, boolean bl) {
        return super.setOrReplace(string, bl);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, boolean bl) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.BooleanValue(bl), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, bl);
    }

    public DocumentMutation setOrReplace(String string, short s) {
        return super.setOrReplace(string, s);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, short s) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.ShortValue(s), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, s);
    }

    public DocumentMutation setOrReplace(String string, byte by) {
        return super.setOrReplace(string, by);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, byte by) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.ByteValue(by), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, by);
    }

    public DocumentMutation setOrReplace(String string, int n) {
        return super.setOrReplace(string, n);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, int n) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.IntValue(n), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, n);
    }

    public DocumentMutation setOrReplace(String string, long l) {
        return super.setOrReplace(string, l);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, long l) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.LongValue(l), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, l);
    }

    public DocumentMutation setOrReplace(String string, float f) {
        return super.setOrReplace(string, f);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, float f) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.FloatValue(f), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, f);
    }

    public DocumentMutation setOrReplace(String string, double d) {
        return super.setOrReplace(string, d);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, double d) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.DoubleValue(d), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, d);
    }

    public MutationImpl setOrReplace(String string, String string2) {
        return super.setOrReplace(string, string2);
    }

    public MutationImpl setOrReplace(FieldPath fieldPath, String string) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.StringValue(string), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, string);
    }

    public DocumentMutation setOrReplace(String string, BigDecimal bigDecimal) {
        return super.setOrReplace(string, bigDecimal);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, BigDecimal bigDecimal) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.DoubleValue(bigDecimal.doubleValue()), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, bigDecimal);
    }

    public DocumentMutation setOrReplace(String string, OTime oTime) {
        return super.setOrReplace(string, oTime);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, OTime oTime) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.TimeValue(new OTime(oTime.toDate())), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, oTime);
    }

    public DocumentMutation setOrReplace(String string, OTimestamp oTimestamp) {
        return super.setOrReplace(string, oTimestamp);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, OTimestamp oTimestamp) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.TimestampValue(oTimestamp), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, oTimestamp);
    }

    public DocumentMutation setOrReplace(String string, ODate oDate) {
        return super.setOrReplace(string, oDate);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, ODate oDate) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.TimeValue(new OTime(oDate.toDate())), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, oDate);
    }

    public DocumentMutation setOrReplace(String string, List<?> list) {
        return super.setOrReplace(string, list);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, List<?> list) {
        return super.setOrReplace(fieldPath, list);
    }

    public DocumentMutation setOrReplace(String string, OInterval oInterval) {
        return super.setOrReplace(string, oInterval);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, OInterval oInterval) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.IntervalValue(oInterval), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, oInterval);
    }

    public DocumentMutation setOrReplace(String string, ByteBuffer byteBuffer) {
        return super.setOrReplace(string, byteBuffer);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, ByteBuffer byteBuffer) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.BinaryValue(byteBuffer), MutationOp.Type.SET_OR_REPLACE);
        return super.setOrReplace(fieldPath, byteBuffer);
    }

    public DocumentMutation setOrReplace(String string, Map<String, ?> map) {
        return super.setOrReplace(string, map);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, Map<String, ?> map) {
        return super.setOrReplace(fieldPath, map);
    }

    public DocumentMutation setOrReplace(String string, Document document) {
        return super.setOrReplace(string, document);
    }

    public DocumentMutation setOrReplace(FieldPath fieldPath, Document document) {
        return super.setOrReplace(fieldPath, document);
    }

    public DocumentMutation append(String string, List<?> list) {
        this.newOp(string, (Value)new Values.ArrayValue(list.toArray()), MutationOp.Type.APPEND);
        return super.append(string, list);
    }

    public DocumentMutation append(FieldPath fieldPath, List<?> list) {
        return super.append(fieldPath, list);
    }

    public DocumentMutation append(String string, String string2) {
        this.newOp(string, (Value)new Values.StringValue(string2), MutationOp.Type.APPEND);
        return super.append(string, string2);
    }

    public DocumentMutation append(FieldPath fieldPath, String string) {
        return super.append(fieldPath, string);
    }

    public DocumentMutation append(String string, byte[] byArray, int n, int n2) {
        return super.append(string, byArray, n, n2);
    }

    public DocumentMutation append(FieldPath fieldPath, byte[] byArray, int n, int n2) {
        return super.append(fieldPath, byArray, n, n2);
    }

    public DocumentMutation append(String string, byte[] byArray) {
        this.newOp(string, (Value)new Values.BinaryValue(ByteBuffer.wrap(byArray)), MutationOp.Type.APPEND);
        return super.append(string, byArray);
    }

    public DocumentMutation append(FieldPath fieldPath, byte[] byArray) {
        return super.append(fieldPath, byArray);
    }

    public DocumentMutation append(String string, ByteBuffer byteBuffer) {
        return super.append(string, byteBuffer);
    }

    public DocumentMutation append(FieldPath fieldPath, ByteBuffer byteBuffer) {
        return super.append(fieldPath, byteBuffer);
    }

    public DocumentMutation merge(String string, Document document) {
        return super.merge(string, document);
    }

    public DocumentMutation merge(FieldPath fieldPath, Document document) {
        return super.merge(fieldPath, document);
    }

    public DocumentMutation merge(String string, Map<String, Object> map) {
        return super.merge(string, map);
    }

    public DocumentMutation merge(FieldPath fieldPath, Map<String, Object> map) {
        return super.merge(fieldPath, map);
    }

    public DocumentMutation increment(FieldPath fieldPath, byte by) {
        return super.increment(fieldPath, by);
    }

    public DocumentMutation increment(String string, byte by) {
        this.newOp(string, (Value)new Values.ByteValue(by), MutationOp.Type.INCREMENT);
        return super.increment(string, by);
    }

    public DocumentMutation increment(FieldPath fieldPath, short s) {
        return super.increment(fieldPath, s);
    }

    public DocumentMutation increment(String string, short s) {
        return super.increment(string, s);
    }

    public MutationImpl increment(String string, int n) {
        this.newOp(string, (Value)new Values.IntValue(n), MutationOp.Type.INCREMENT);
        return super.increment(string, n);
    }

    public DocumentMutation increment(FieldPath fieldPath, int n) {
        return super.increment(fieldPath, n);
    }

    public DocumentMutation increment(FieldPath fieldPath, long l) {
        return super.increment(fieldPath, l);
    }

    public DocumentMutation increment(String string, long l) {
        this.newOp(string, (Value)new Values.LongValue(l), MutationOp.Type.INCREMENT);
        return super.increment(string, l);
    }

    public DocumentMutation increment(String string, float f) {
        this.newOp(string, (Value)new Values.FloatValue(f), MutationOp.Type.INCREMENT);
        return super.increment(string, f);
    }

    public DocumentMutation increment(FieldPath fieldPath, float f) {
        return super.increment(fieldPath, f);
    }

    public DocumentMutation increment(String string, double d) {
        this.newOp(string, (Value)new Values.DoubleValue(d), MutationOp.Type.INCREMENT);
        return super.increment(string, d);
    }

    public DocumentMutation increment(FieldPath fieldPath, double d) {
        return super.increment(fieldPath, d);
    }

    public DocumentMutation increment(String string, BigDecimal bigDecimal) {
        this.newOp(string, (Value)new Values.DecimalValue(bigDecimal), MutationOp.Type.INCREMENT);
        return super.increment(string, bigDecimal);
    }

    public DocumentMutation increment(FieldPath fieldPath, BigDecimal bigDecimal) {
        return super.increment(fieldPath, bigDecimal);
    }

    public DocumentMutation delete(String string) {
        return super.delete(string);
    }

    public DocumentMutation delete(FieldPath fieldPath) {
        this.newOp(fieldPath.asPathString(), null, MutationOp.Type.DELETE);
        return super.delete(fieldPath);
    }

    public boolean needsReadOnServer() {
        return super.needsReadOnServer();
    }

    public ByteBuffer rowcolSerialize() {
        return super.rowcolSerialize();
    }

    public SerializedFamilyInfo[] rowcolSerialize(Map<FieldPath, Integer> map, boolean bl) {
        return super.rowcolSerialize(map, bl);
    }

    public Map<Integer, List<String>> getFieldsNeedRead(Map<FieldPath, Integer> map) {
        return super.getFieldsNeedRead(map);
    }

    public SerializedFamilyInfo[] rowcolSerialize(Map<FieldPath, Integer> map) {
        return super.rowcolSerialize(map);
    }

    public Iterator<MutationOp> iterator() {
        return this.ops.iterator();
    }

    public DocumentMutation decrement(FieldPath fieldPath, byte by) {
        this.newOp(fieldPath.asPathString(), (Value)DBValueBuilderImpl.KeyValueBuilder.initFrom((int)(-by)), MutationOp.Type.INCREMENT);
        return super.decrement(fieldPath, by);
    }

    public DocumentMutation decrement(String string, byte by) {
        this.newOp(string, (Value)DBValueBuilderImpl.KeyValueBuilder.initFrom((int)(-by)), MutationOp.Type.INCREMENT);
        return super.decrement(string, by);
    }

    public DocumentMutation decrement(FieldPath fieldPath, short s) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.ShortValue((short)(-1 * s)), MutationOp.Type.INCREMENT);
        return super.decrement(fieldPath, s);
    }

    public DocumentMutation decrement(String string, short s) {
        this.newOp(string, (Value)new Values.ShortValue((short)(-1 * s)), MutationOp.Type.INCREMENT);
        return super.decrement(string, s);
    }

    public DocumentMutation decrement(String string, int n) {
        this.newOp(string, (Value)new Values.IntValue(-n), MutationOp.Type.INCREMENT);
        return super.decrement(string, n);
    }

    public DocumentMutation decrement(FieldPath fieldPath, int n) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.IntValue(-n), MutationOp.Type.INCREMENT);
        return super.decrement(fieldPath, n);
    }

    public DocumentMutation decrement(FieldPath fieldPath, long l) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.LongValue(-l), MutationOp.Type.INCREMENT);
        return super.decrement(fieldPath, l);
    }

    public DocumentMutation decrement(String string, long l) {
        this.newOp(string, (Value)new Values.LongValue(-l), MutationOp.Type.INCREMENT);
        return super.decrement(string, l);
    }

    public DocumentMutation decrement(String string, float f) {
        this.newOp(string, (Value)new Values.FloatValue(-f), MutationOp.Type.INCREMENT);
        return super.decrement(string, f);
    }

    public DocumentMutation decrement(FieldPath fieldPath, float f) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.FloatValue(-f), MutationOp.Type.INCREMENT);
        return super.decrement(fieldPath, f);
    }

    public DocumentMutation decrement(String string, double d) {
        this.newOp(string, (Value)new Values.DoubleValue(-d), MutationOp.Type.INCREMENT);
        return super.decrement(string, d);
    }

    public DocumentMutation decrement(FieldPath fieldPath, double d) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.DoubleValue(-d), MutationOp.Type.INCREMENT);
        return super.decrement(fieldPath, d);
    }

    public DocumentMutation decrement(String string, BigDecimal bigDecimal) {
        this.newOp(string, (Value)new Values.DecimalValue(bigDecimal.multiply(BigDecimal.valueOf(-1L))), MutationOp.Type.INCREMENT);
        return super.decrement(string, bigDecimal);
    }

    public DocumentMutation decrement(FieldPath fieldPath, BigDecimal bigDecimal) {
        this.newOp(fieldPath.asPathString(), (Value)new Values.DecimalValue(bigDecimal.multiply(BigDecimal.valueOf(-1L))), MutationOp.Type.INCREMENT);
        return super.decrement(fieldPath, bigDecimal);
    }
}

